/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XsuaaJkuValidator
implements Validator<Token> {
    private final String domain;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    XsuaaJkuValidator(String uaaDomain) {
        Assertions.assertHasText((String)uaaDomain, (String)"XsuaaJkuValidator requires uaaDomain.");
        this.domain = uaaDomain;
    }

    @Override
    public ValidationResult validate(Token token) {
        URI jkuUri;
        String tokenKeyUrl = token.getHeaderParameterAsString("jku");
        if (tokenKeyUrl == null || tokenKeyUrl.trim().isEmpty()) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain 'jku' header parameter.");
        }
        try {
            jkuUri = URI.create(tokenKeyUrl);
        }
        catch (IllegalArgumentException e) {
            return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain a valid uri as 'jku' header parameter.");
        }
        if (!this.matchesTokenKeyUrlDomain(jkuUri)) {
            return ValidationResults.createInvalid("Issuer is not trusted because 'jku' '{}' does not match uaa domain '{}' of the identity service.", jkuUri, this.domain);
        }
        if (!this.matchesTokenKeyEndpoint(jkuUri)) {
            return ValidationResults.createInvalid("Jwt token does not contain a valid 'jku' header parameter.", jkuUri, this.domain);
        }
        return ValidationResults.createValid();
    }

    private boolean matchesTokenKeyUrlDomain(URI jkuUri) {
        return jkuUri.getHost() != null && jkuUri.getHost().endsWith(this.domain);
    }

    private boolean matchesTokenKeyEndpoint(URI jkuUri) {
        return jkuUri.getPath().endsWith("token_keys") && jkuUri.getQuery() == null && jkuUri.getFragment() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsuaaJkuValidator that = (XsuaaJkuValidator)o;
        return this.domain.equals(that.domain);
    }

    public int hashCode() {
        return this.domain.hashCode();
    }
}

