/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemRecord
implements Serializable {
    private static final long serialVersionUID = -3294038187552297656L;
    private final Map<String, Object> propertyMap;
    private final String itemId;
    private final String itemType;

    private ItemRecord(Map<String, Object> propertyMap, String itemId, String itemType) {
        this.propertyMap = propertyMap;
        this.itemId = itemId;
        this.itemType = itemType;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getItemType() {
        return this.itemType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String itemId;
        private String itemType;

        private Builder() {
        }

        public ItemRecord build() throws InvalidArgumentException {
            if (null == this.itemId) {
                throw new InvalidArgumentException("The itemId is empty.");
            }
            if (null == this.itemType) {
                throw new InvalidArgumentException("The itemType is empty.");
            }
            return new ItemRecord(this.propertyMap, this.itemId, this.itemType);
        }

        public Builder setItemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder setItemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

