/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriter;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriterFactory;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

class InnerLoggingConsumer
implements Consumer {
    private static final int BUFFER_LIMITATION = 0x40000000;
    private final ObjectMapper jsonMapper;
    private final String filenamePrefix;
    private final StringBuilder messageBuffer;
    private final int bufferSize;
    private final SimpleDateFormat simpleDateFormat;
    private final LoggingFileWriterFactory fileWriterFactory;
    private LoggingFileWriter fileWriter;

    InnerLoggingConsumer(LoggingFileWriterFactory fileWriterFactory, String filenamePrefix, int bufferSize, LogSplitMode splitMode) throws IOException {
        this.fileWriterFactory = fileWriterFactory;
        this.filenamePrefix = filenamePrefix;
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        this.messageBuffer = new StringBuilder(bufferSize);
        this.bufferSize = bufferSize;
        this.simpleDateFormat = splitMode == LogSplitMode.HOUR ? new SimpleDateFormat("yyyy-MM-dd-HH") : new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public synchronized void send(Map<String, Object> message) {
        if (this.messageBuffer.length() < 0x40000000) {
            try {
                this.messageBuffer.append(this.jsonMapper.writeValueAsString(message));
                this.messageBuffer.append("\n");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("fail to process json", e);
            }
        } else {
            throw new RuntimeException("logging buffer exceeded the allowed limitation.");
        }
        if (this.messageBuffer.length() >= this.bufferSize) {
            this.flush();
        }
    }

    private String constructFileName(Date now) {
        return this.filenamePrefix + "." + this.simpleDateFormat.format(now);
    }

    @Override
    public synchronized void flush() {
        if (this.messageBuffer.length() == 0) {
            return;
        }
        String filename = this.constructFileName(new Date());
        if (this.fileWriter != null && !this.fileWriter.isValid(filename)) {
            this.fileWriterFactory.closeFileWriter(this.fileWriter);
            this.fileWriter = null;
        }
        if (this.fileWriter == null) {
            try {
                this.fileWriter = this.fileWriterFactory.getFileWriter(this.filenamePrefix, filename);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.fileWriter.write(this.messageBuffer)) {
            this.messageBuffer.setLength(0);
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
        if (this.fileWriter != null) {
            this.fileWriterFactory.closeFileWriter(this.fileWriter);
            this.fileWriter = null;
        }
    }

    public static enum LogSplitMode {
        DAY,
        HOUR;

    }
}

