/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class SensorsAnalyticsUtil {
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$|^user_group|^user_tag)[a-zA-Z_$][a-zA-Z\\d_$]{0,99})$", 2);

    public static String strJoin(String[] arr, String sep) {
        StringBuilder sbStr = new StringBuilder();
        int il = arr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sep);
            }
            sbStr.append(arr[i]);
        }
        return sbStr.toString();
    }

    public static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        jsonObjectMapper.setTimeZone(TimeZone.getDefault());
        jsonObjectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        return jsonObjectMapper;
    }

    public static void assertProperties(String eventType, Map<String, Object> properties) throws InvalidArgumentException {
        if (null == properties) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean isFilterKey;
            String value;
            if (property.getKey().equals("$is_login_id")) {
                if (property.getValue() instanceof Boolean) continue;
                throw new InvalidArgumentException("The property value of '$is_login_id' should be Boolean.");
            }
            SensorsAnalyticsUtil.assertKey("property", property.getKey());
            if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean || property.getValue() instanceof List)) {
                throw new InvalidArgumentException("The property '" + property.getKey() + "' should be a basic type: Number, String, Date, Boolean, List<String>.");
            }
            if (property.getKey().equals("$time") && !(property.getValue() instanceof Date)) {
                throw new InvalidArgumentException("The property '$time' should be a java.util.Date.");
            }
            if (property.getValue() instanceof List && !eventType.equals("profile_increment")) {
                ListIterator<String> it = ((List)property.getValue()).listIterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (!(element instanceof String)) {
                        throw new InvalidArgumentException("The property '" + property.getKey() + "' should be a list of String.");
                    }
                    if (((String)element).length() <= 8192) continue;
                    it.set(((String)element).substring(0, 8192));
                }
            }
            if (property.getValue() instanceof String && (value = (String)property.getValue()).length() > 8192) {
                property.setValue(value.substring(0, 8192));
            }
            boolean bl = isFilterKey = property.getKey().equals("$project") || property.getKey().equals("$token");
            if (eventType.equals("profile_increment")) {
                if (isFilterKey || property.getValue() instanceof Number) continue;
                throw new InvalidArgumentException("The property value of PROFILE_INCREMENT should be a Number.");
            }
            if (!eventType.equals("profile_append") || isFilterKey || property.getValue() instanceof List) continue;
            throw new InvalidArgumentException("The property value of PROFILE_APPEND should be a List<String>.");
        }
    }

    public static void assertValue(String type, String value) throws InvalidArgumentException {
        if (value == null || value.length() < 1) {
            throw new InvalidArgumentException("The value is empty or null.");
        }
        if (value.length() > 255) {
            throw new InvalidArgumentException("The " + type + " value '" + value + "' is too long, max length is 255.");
        }
    }

    public static void assertKey(String type, String key) throws InvalidArgumentException {
        if (null == key || key.length() < 1) {
            throw new InvalidArgumentException("The key is empty or null.");
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            throw new InvalidArgumentException("The " + type + " key '" + key + "' is invalid.");
        }
    }
}

