/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errcount;

import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class ConsecutiveCounter
extends HalfOpenCounter {
    private final Map<StatusDimension, AtomicInteger> consecutiveErrors = new HashMap<StatusDimension, AtomicInteger>();
    private final Function<StatusDimension, AtomicInteger> create = new Function<StatusDimension, AtomicInteger>(){

        @Override
        public AtomicInteger apply(StatusDimension statusDimension) {
            return new AtomicInteger(0);
        }
    };

    private AtomicInteger getCounter(StatusDimension statusDimension) {
        return this.consecutiveErrors.computeIfAbsent(statusDimension, this.create);
    }

    public Set<StatusDimension> getStatusDimensions() {
        return this.consecutiveErrors.keySet();
    }

    public int onFail(StatusDimension statusDimension) {
        AtomicInteger counter = this.getCounter(statusDimension);
        return counter.incrementAndGet();
    }

    public int getConsecutiveErrorCount(StatusDimension statusDimension) {
        AtomicInteger counter = this.getCounter(statusDimension);
        return counter.get();
    }

    public void resetCounter(StatusDimension statusDimension) {
        AtomicInteger counter = this.getCounter(statusDimension);
        counter.set(0);
    }
}

