/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.tcp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.tcp.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.slf4j.Logger;

public class TcpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TcpHealthChecker.class);
    private Config config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public DetectResult detectInstance(Instance instance) throws PolarisException {
        DetectResult detectResult;
        Socket socket;
        int port;
        String host;
        block21: {
            block19: {
                DetectResult detectResult2;
                block20: {
                    String expectRecvStr;
                    String sendStr;
                    block17: {
                        DetectResult detectResult3;
                        block18: {
                            boolean needSendData;
                            host = instance.getHost();
                            port = instance.getPort();
                            socket = null;
                            socket = new Socket(host, port);
                            sendStr = this.config.getSend();
                            expectRecvStr = this.config.getReceive();
                            boolean bl = needSendData = sendStr != null && !"".equals(sendStr);
                            if (needSendData) break block17;
                            detectResult3 = new DetectResult(RetStatus.RetSuccess);
                            if (socket == null) break block18;
                            try {
                                socket.close();
                            }
                            catch (IOException e) {
                                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
                            }
                        }
                        return detectResult3;
                    }
                    byte[] sendBytes = sendStr.getBytes("UTF8");
                    byte[] expectRecvBytes = expectRecvStr.getBytes("UTF8");
                    OutputStream os = socket.getOutputStream();
                    os.write(sendBytes);
                    byte[] recvBytes = this.recvFromSocket(socket, expectRecvBytes.length);
                    if (!Arrays.equals(Arrays.copyOfRange(recvBytes, 0, expectRecvBytes.length), expectRecvBytes)) break block19;
                    detectResult2 = new DetectResult(RetStatus.RetSuccess);
                    if (socket == null) break block20;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
                    }
                }
                return detectResult2;
            }
            detectResult = new DetectResult(RetStatus.RetFail);
            if (socket == null) break block21;
            try {
                socket.close();
            }
            catch (IOException e) {
                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
            }
        }
        return detectResult;
        catch (IOException e) {
            DetectResult detectResult4;
            block22: {
                try {
                    LOG.warn("tcp detect instance, create sock exception, host:{}, port:{}.", (Object)host, (Object)port);
                    detectResult4 = new DetectResult(RetStatus.RetFail);
                    if (socket == null) break block22;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e2) {
                            LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e2});
                        }
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException e3) {
                    LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e3});
                }
            }
            return detectResult4;
        }
    }

    private byte[] recvFromSocket(Socket socket, int maxLen) throws IOException {
        InputStream is = socket.getInputStream();
        byte[] recvBytes = new byte[1024];
        int recvLen = 0;
        while (recvLen + maxLen <= recvBytes.length) {
            int tempLen = is.read(recvBytes, recvLen, maxLen);
            if (tempLen < 0) {
                return recvBytes;
            }
            if ((recvLen += tempLen) >= maxLen) continue;
        }
        return recvBytes;
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "tcp";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        if (cfg == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        this.config = cfg;
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

