/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.udp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.udp.Config;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import org.slf4j.Logger;

public class UdpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UdpHealthChecker.class);
    private Config config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectResult detectInstance(Instance instance) throws PolarisException {
        try (DatagramSocket socket = null;){
            String sendStr = this.config.getSend();
            InetAddress inet = InetAddress.getByName(instance.getHost());
            byte[] sendBytes = sendStr.getBytes("UTF8");
            socket = new DatagramSocket();
            socket.setSoTimeout(this.config.getTimeout().intValue());
            DatagramPacket sendPacket = new DatagramPacket(sendBytes, sendBytes.length, inet, instance.getPort());
            socket.send(sendPacket);
            byte[] recvBuf = new byte[1024];
            DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
            socket.receive(recvPacket);
            socket.close();
            String expectRecvStr = this.config.getReceive();
            byte[] expectRecvBytes = expectRecvStr.getBytes("UTF8");
            if (!Arrays.equals(Arrays.copyOfRange(recvBuf, 0, expectRecvBytes.length), expectRecvBytes)) {
                DetectResult detectResult = new DetectResult(RetStatus.RetFail);
                return detectResult;
            }
            DetectResult detectResult = new DetectResult(RetStatus.RetSuccess);
            return detectResult;
        }
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "udp";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        if (cfg == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        this.config = cfg;
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

