/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.location.remoteservice;

import com.google.protobuf.StringValue;
import com.tencent.polaris.api.plugin.location.LocationProvider;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pb.LocationGRPCGrpc;
import com.tencent.polaris.client.pb.LocationGRPCService;
import com.tencent.polaris.client.pb.ModelProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugin.location.base.BaseLocationProvider;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.Socket;
import org.slf4j.Logger;

public class RemoteServiceLocationProvider
extends BaseLocationProvider<ServiceOption> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceLocationProvider.class);
    private LocationGRPCGrpc.LocationGRPCBlockingStub stub;

    public RemoteServiceLocationProvider() {
        super(ServiceOption.class);
    }

    public LocationProvider.ProviderType getProviderType() {
        return LocationProvider.ProviderType.REMOTE_SERVICE;
    }

    public ModelProto.Location doGet(ServiceOption option) {
        this.buildGrpcStub(option);
        try {
            LocationGRPCService.LocationResponse response = this.stub.getLocation(LocationGRPCService.LocationRequest.newBuilder().setClientIp(this.getLocalHost(option.getTarget())).build());
            return ModelProto.Location.newBuilder().setRegion(StringValue.newBuilder().setValue(StringUtils.defaultString((String)response.getRegion())).build()).setZone(StringValue.newBuilder().setValue(StringUtils.defaultString((String)response.getZone())).build()).setCampus(StringValue.newBuilder().setValue(StringUtils.defaultString((String)response.getCampus())).build()).build();
        }
        catch (Exception e) {
            LOGGER.error("[Location][Provider][RemoteService] get location from remote service fail, option : {}", (Object)option, (Object)e);
            return null;
        }
    }

    public synchronized void buildGrpcStub(ServiceOption option) {
        if (this.stub != null) {
            return;
        }
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)option.getTarget()).usePlaintext().build();
        this.stub = LocationGRPCGrpc.newBlockingStub((Channel)channel);
    }

    private String getLocalHost(String addresses) throws Exception {
        if (addresses == null || addresses.length() == 0) {
            return this.configuration.getGlobal().getAPI().getBindIP();
        }
        String[] addressList = addresses.split(",");
        String[] tokens = addressList[0].split(":");
        try (Socket socket = new Socket(tokens[0], Integer.parseInt(tokens[1]));){
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
    }

    public static class ServiceOption {
        private String target;

        String getTarget() {
            return this.target;
        }

        void setTarget(String target) {
            this.target = target;
        }
    }
}

