/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.factory;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.client.DefaultConfigFileService;
import com.tencent.polaris.factory.ConfigAPIFactory;

public class ConfigFileServiceFactory {
    private static DefaultConfigFileService configFileService;

    public static ConfigFileService createConfigFileService() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return ConfigFileServiceFactory.createConfigFileService(configuration);
    }

    public static ConfigFileService createConfigFileService(Configuration config) throws PolarisException {
        SDKContext context = SDKContext.initContextByConfig((Configuration)config);
        return ConfigFileServiceFactory.createConfigFileService(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigFileService createConfigFileService(SDKContext sdkContext) throws PolarisException {
        if (configFileService != null) return configFileService;
        Class<ConfigFileServiceFactory> clazz = ConfigFileServiceFactory.class;
        synchronized (ConfigFileServiceFactory.class) {
            if (configFileService != null) return configFileService;
            configFileService = new DefaultConfigFileService(sdkContext);
            configFileService.init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configFileService;
        }
    }
}

