/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.test.common;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import java.util.Arrays;
import java.util.Collections;

public class TestUtils {
    public static final String SERVER_ADDRESS_ENV = "POLARIS_SEVER_ADDRESS";

    private static String[] getServerAddressFromEnv() {
        String addressStr = System.getenv(SERVER_ADDRESS_ENV);
        if (StringUtils.isBlank((String)addressStr)) {
            return null;
        }
        return addressStr.split(",");
    }

    private static String[] getServerAddressFromProperties() {
        String addressStr = System.getProperty(SERVER_ADDRESS_ENV);
        if (StringUtils.isBlank((String)addressStr)) {
            return null;
        }
        return addressStr.split(",");
    }

    public static Configuration configWithEnvAddress() {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        String[] addresses = TestUtils.getServerAddressFromEnv();
        if (addresses == null) {
            addresses = TestUtils.getServerAddressFromProperties();
        }
        if (null != addresses) {
            ConfigurationImpl configurationImpl = (ConfigurationImpl)configuration;
            configurationImpl.setDefault();
            configurationImpl.getGlobal().getServerConnector().setAddresses(Arrays.asList((Object[])addresses.clone()));
        }
        return configuration;
    }

    public static Configuration createSimpleConfiguration(int port) {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setDefault();
        configuration.getGlobal().getServerConnector().setAddresses(Collections.singletonList(String.format("127.0.0.1:%d", port)));
        return configuration;
    }
}

