/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.tencent.polaris.api.plugin.stat.CircuitBreakGauge;
import com.tencent.polaris.api.plugin.stat.RateLimitGauge;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.common.model.AbstractSignatureStatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategy;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategyCollections;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollectorContainer;
import com.tencent.polaris.plugins.stat.common.model.StatInfoHandler;
import com.tencent.polaris.plugins.stat.common.model.StatInfoRevisionCollector;
import com.tencent.polaris.plugins.stat.common.model.StatMetric;
import com.tencent.polaris.plugins.stat.common.model.StatRevisionMetric;
import com.tencent.polaris.plugins.stat.common.model.SystemMetricModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import shade.polaris.io.prometheus.client.CollectorRegistry;
import shade.polaris.io.prometheus.client.Gauge;

public class PrometheusHandler
implements StatInfoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusHandler.class);
    public static final int DEFAULT_INTERVAL_MILLI = 30000;
    public static final int REVISION_MAX_SCOPE = 2;
    private final AtomicBoolean firstHandle = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledAggregationTask;
    private StatInfoCollectorContainer container;
    private final String callerIp;
    private final CollectorRegistry promRegistry;
    private final Map<String, Gauge> sampleMapping;

    public PrometheusHandler(String callerIp) {
        this.callerIp = callerIp;
        this.container = new StatInfoCollectorContainer();
        this.sampleMapping = new HashMap<String, Gauge>();
        this.promRegistry = new CollectorRegistry(true);
        this.scheduledAggregationTask = Executors.newSingleThreadScheduledExecutor();
        this.initSampleMapping(MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
    }

    private void initSampleMapping(MetricValueAggregationStrategy<?>[] strategies, String[] order) {
        for (MetricValueAggregationStrategy<?> strategy : strategies) {
            Gauge strategyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)new Gauge.Builder().name(strategy.getStrategyName())).help(strategy.getStrategyDescription())).labelNames(order)).create().register(this.promRegistry);
            this.sampleMapping.put(strategy.getStrategyName(), strategyGauge);
        }
    }

    public void handle(StatInfo statInfo) {
        if (this.firstHandle.compareAndSet(false, true)) {
            this.startScheduleAggregationTask();
        }
        if (null == statInfo) {
            return;
        }
        if (null != statInfo.getRouterGauge()) {
            this.handleRouterGauge(statInfo.getRouterGauge());
        }
        if (null != statInfo.getCircuitBreakGauge()) {
            this.handleCircuitBreakGauge(statInfo.getCircuitBreakGauge());
        }
        if (null != statInfo.getRateLimitGauge()) {
            this.handleRateLimitGauge(statInfo.getRateLimitGauge());
        }
    }

    public void handleRouterGauge(InstanceGauge instanceGauge) {
        if (null != this.container && null != this.container.getInsCollector()) {
            this.container.getInsCollector().collectStatInfo((Object)instanceGauge, this.convertInsGaugeToLabels(instanceGauge), MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY);
        }
    }

    public void handleRateLimitGauge(RateLimitGauge rateLimitGauge) {
        if (null != this.container && null != this.container.getRateLimitCollector()) {
            this.container.getRateLimitCollector().collectStatInfo((Object)rateLimitGauge, this.convertRateLimitGaugeToLabels(rateLimitGauge), MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY);
        }
    }

    public void handleCircuitBreakGauge(CircuitBreakGauge circuitBreakGauge) {
        if (null != this.container && null != this.container.getCircuitBreakerCollector()) {
            this.container.getCircuitBreakerCollector().collectStatInfo((Object)circuitBreakGauge, this.convertCircuitBreakToLabels(circuitBreakGauge), MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY);
        }
    }

    public void stopHandle() {
        if (this.container != null) {
            this.container = null;
        }
        if (this.scheduledAggregationTask != null) {
            this.scheduledAggregationTask.shutdown();
            this.scheduledAggregationTask = null;
        }
    }

    private void startScheduleAggregationTask() {
        if (null != this.container && null != this.scheduledAggregationTask && null != this.sampleMapping) {
            this.scheduledAggregationTask.scheduleWithFixedDelay(this::doAggregation, 30000L, 30000L, TimeUnit.MILLISECONDS);
            LOG.info("start schedule metric aggregation task, task interval {}", (Object)30000);
        }
    }

    private void doAggregation() {
        this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getInsCollector(), this.container.getInsCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
        this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getRateLimitCollector(), this.container.getRateLimitCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
        this.putDataFromContainerInOrder((AbstractSignatureStatInfoCollector<?, ? extends StatMetric>)this.container.getCircuitBreakerCollector(), 0L, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
        for (StatInfoCollector s : this.container.getCollectors()) {
            if (!(s instanceof StatInfoRevisionCollector)) continue;
            long currentRevision = ((StatInfoRevisionCollector)s).incRevision();
            LOG.debug("RevisionCollector inc current revision to {}", (Object)currentRevision);
        }
    }

    private void putDataFromContainerInOrder(AbstractSignatureStatInfoCollector<?, ? extends StatMetric> collector, long currentRevision, String[] order) {
        Collection values = collector.getCollectedValues();
        for (StatMetric s : values) {
            Gauge.Child child;
            Gauge gauge = this.sampleMapping.get(s.getMetricName());
            if (null == gauge) continue;
            if (s instanceof StatRevisionMetric) {
                StatRevisionMetric rs = (StatRevisionMetric)s;
                if (rs.getRevision() < currentRevision - 2L) {
                    gauge.remove(PrometheusHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    collector.getMetricContainer().remove(s.getSignature());
                    continue;
                }
                if (rs.getRevision() < currentRevision) {
                    gauge.remove(PrometheusHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    Gauge.Child child2 = (Gauge.Child)gauge.labels(PrometheusHandler.getOrderedMetricLabelValues(s.getLabels(), order));
                    if (null == child2) continue;
                    child2.set(0.0);
                    continue;
                }
            }
            if (null == (child = (Gauge.Child)gauge.labels(PrometheusHandler.getOrderedMetricLabelValues(s.getLabels(), order)))) continue;
            child.set(s.getValue());
        }
    }

    public static String[] getOrderedMetricLabelValues(Map<String, String> labels, String[] orderedKey) {
        String[] orderValue = new String[orderedKey.length];
        for (int i = 0; i < orderedKey.length; ++i) {
            orderValue[i] = labels.getOrDefault(orderedKey[i], "__NULL__");
        }
        return orderValue;
    }

    protected Map<String, String> convertInsGaugeToLabels(InstanceGauge insGauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, insGauge.getNamespace(), labels);
                    continue block24;
                }
                case "callee_service": {
                    this.addLabel(labelName, insGauge.getService(), labels);
                    continue block24;
                }
                case "callee_method": {
                    this.addLabel(labelName, insGauge.getMethod(), labels);
                    continue block24;
                }
                case "callee_subset": {
                    this.addLabel(labelName, insGauge.getSubset(), labels);
                    continue block24;
                }
                case "callee_instance": {
                    this.addLabel(labelName, PrometheusHandler.buildAddress(insGauge.getHost(), insGauge.getPort()), labels);
                    continue block24;
                }
                case "callee_result_code": {
                    String retCodeStr = null == insGauge.getRetCode() ? null : insGauge.getRetCode().toString();
                    this.addLabel(labelName, retCodeStr, labels);
                    continue block24;
                }
                case "caller_labels": {
                    this.addLabel(labelName, insGauge.getLabels(), labels);
                    continue block24;
                }
                case "caller_namespace": {
                    String namespace = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getNamespace();
                    this.addLabel(labelName, namespace, labels);
                    continue block24;
                }
                case "caller_service": {
                    String serviceName = null == insGauge.getCallerService() ? null : insGauge.getCallerService().getService();
                    this.addLabel(labelName, serviceName, labels);
                    continue block24;
                }
                case "caller_ip": {
                    this.addLabel(labelName, this.callerIp, labels);
                    continue block24;
                }
            }
        }
        return labels;
    }

    protected Map<String, String> convertRateLimitGaugeToLabels(RateLimitGauge rateLimitGauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, rateLimitGauge.getNamespace(), labels);
                    continue block12;
                }
                case "callee_service": {
                    this.addLabel(labelName, rateLimitGauge.getService(), labels);
                    continue block12;
                }
                case "callee_method": {
                    this.addLabel(labelName, rateLimitGauge.getMethod(), labels);
                    continue block12;
                }
                case "caller_labels": {
                    this.addLabel(labelName, rateLimitGauge.getLabels(), labels);
                    continue block12;
                }
            }
        }
        return labels;
    }

    protected Map<String, String> convertCircuitBreakToLabels(CircuitBreakGauge gauge) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String[] stringArray = SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER;
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String labelName;
            switch (labelName = stringArray[i]) {
                case "callee_namespace": {
                    this.addLabel(labelName, gauge.getNamespace(), labels);
                    continue block20;
                }
                case "callee_service": {
                    this.addLabel(labelName, gauge.getService(), labels);
                    continue block20;
                }
                case "callee_method": {
                    this.addLabel(labelName, gauge.getMethod(), labels);
                    continue block20;
                }
                case "callee_subset": {
                    this.addLabel(labelName, gauge.getSubset(), labels);
                    continue block20;
                }
                case "callee_instance": {
                    this.addLabel(labelName, PrometheusHandler.buildAddress(gauge.getHost(), gauge.getPort()), labels);
                    continue block20;
                }
                case "caller_namespace": {
                    String namespace = null == gauge.getCallerService() ? null : gauge.getCallerService().getNamespace();
                    this.addLabel(labelName, namespace, labels);
                    continue block20;
                }
                case "caller_service": {
                    String serviceName = null == gauge.getCallerService() ? null : gauge.getCallerService().getService();
                    this.addLabel(labelName, serviceName, labels);
                    continue block20;
                }
                case "caller_ip": {
                    this.addLabel(labelName, this.callerIp, labels);
                    continue block20;
                }
            }
        }
        return labels;
    }

    private void addLabel(String key, String value, Map<String, String> target) {
        if (null == key) {
            return;
        }
        if (null == value) {
            value = "__NULL__";
        }
        target.put(key, value);
    }

    private static String buildAddress(String host, int port) {
        if (null == host) {
            host = "";
        }
        return host + ":" + port;
    }

    public CollectorRegistry getPromRegistry() {
        return this.promRegistry;
    }
}

