/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.ObjectProxy;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.rpc.loadbalance.DefaultLoadBalance;
import com.qq.tars.client.rpc.tars.TarsProtocolInvoker;
import com.qq.tars.client.support.ServantCacheManager;
import com.qq.tars.client.util.ParseTools;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.annotation.ServantCodec;
import com.qq.tars.register.RegisterManager;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.ProtocolInvoker;
import com.qq.tars.rpc.exc.ClientException;
import com.qq.tars.rpc.exc.CommunicatorConfigException;
import com.qq.tars.rpc.protocol.Codec;
import com.qq.tars.rpc.protocol.ServantProtocolFactory;
import com.qq.tars.rpc.protocol.tars.TarsCodec;
import com.qq.tars.support.log.LoggerFactory;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;

class ObjectProxyFactory {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final Communicator communicator;

    public ObjectProxyFactory(Communicator communicator) {
        this.communicator = communicator;
    }

    public <T> ObjectProxy<T> getObjectProxy(Class<T> api, String objName, String setDivision, ServantProxyConfig servantProxyConfig, LoadBalance<T> loadBalance, ProtocolInvoker<T> protocolInvoker) throws ClientException {
        if (servantProxyConfig == null) {
            servantProxyConfig = this.createServantProxyConfig(objName, setDivision);
        } else {
            servantProxyConfig.setCommunicatorId(this.communicator.getId());
            servantProxyConfig.setModuleName(this.communicator.getCommunicatorConfig().getModuleName(), this.communicator.getCommunicatorConfig().isEnableSet(), this.communicator.getCommunicatorConfig().getSetDivision());
            servantProxyConfig.setLocator(this.communicator.getCommunicatorConfig().getLocator());
            this.addSetDivisionInfo(servantProxyConfig, setDivision);
            servantProxyConfig.setRefreshInterval(this.communicator.getCommunicatorConfig().getRefreshEndpointInterval());
            servantProxyConfig.setReportInterval(this.communicator.getCommunicatorConfig().getReportInterval());
        }
        this.updateServantEndpoints(servantProxyConfig);
        if (loadBalance == null) {
            loadBalance = this.createLoadBalance(servantProxyConfig);
        }
        if (protocolInvoker == null) {
            protocolInvoker = this.createProtocolInvoker(api, servantProxyConfig);
        }
        return new ObjectProxy<T>(api, servantProxyConfig, loadBalance, protocolInvoker, this.communicator);
    }

    private <T> ProtocolInvoker<T> createProtocolInvoker(Class<T> api, ServantProxyConfig servantProxyConfig) throws ClientException {
        TarsProtocolInvoker<T> protocolInvoker = null;
        Codec codec = this.createCodec(api, servantProxyConfig);
        if (api.isAnnotationPresent(Servant.class)) {
            if (codec == null) {
                codec = new TarsCodec(servantProxyConfig.getCharsetName());
            }
        } else {
            throw new ClientException(servantProxyConfig.getSimpleObjectName(), "unknown protocol servant invoker", null);
        }
        servantProxyConfig.setProtocol(codec.getProtocol());
        protocolInvoker = new TarsProtocolInvoker<T>(api, servantProxyConfig, new ServantProtocolFactory(codec), this.communicator.getThreadPoolExecutor());
        return protocolInvoker;
    }

    private <T> LoadBalance<T> createLoadBalance(ServantProxyConfig servantProxyConfig) {
        return new DefaultLoadBalance(servantProxyConfig);
    }

    private <T> Codec createCodec(Class<T> api, ServantProxyConfig servantProxyConfig) throws ClientException {
        Class<? extends Codec> codecClass;
        Codec codec = null;
        ServantCodec servantCodec = api.getAnnotation(ServantCodec.class);
        if (servantCodec != null && (codecClass = servantCodec.codec()) != null) {
            try {
                Constructor<? extends Codec> constructor = codecClass.getConstructor(String.class);
                codec = constructor.newInstance(servantProxyConfig.getCharsetName());
            }
            catch (Exception e) {
                throw new ClientException(servantProxyConfig.getSimpleObjectName(), "error occurred on create codec, codec=" + codecClass.getName(), e);
            }
        }
        return codec;
    }

    private ServantProxyConfig createServantProxyConfig(String objName, String setDivision) throws CommunicatorConfigException {
        CommunicatorConfig communicatorConfig = this.communicator.getCommunicatorConfig();
        ServantProxyConfig cfg = new ServantProxyConfig(this.communicator.getId(), communicatorConfig.getLocator(), objName);
        cfg.setAsyncTimeout(communicatorConfig.getAsyncInvokeTimeout());
        cfg.setSyncTimeout(communicatorConfig.getSyncInvokeTimeout());
        this.addSetDivisionInfo(cfg, setDivision);
        cfg.setModuleName(communicatorConfig.getModuleName(), communicatorConfig.isEnableSet(), communicatorConfig.getSetDivision());
        cfg.setStat(communicatorConfig.getStat());
        cfg.setCharsetName(communicatorConfig.getCharsetName());
        cfg.setConnections(communicatorConfig.getConnections());
        cfg.setRefreshInterval(communicatorConfig.getRefreshEndpointInterval());
        cfg.setReportInterval(this.communicator.getCommunicatorConfig().getReportInterval());
        return cfg;
    }

    public void addSetDivisionInfo(ServantProxyConfig cfg, String setDivision) {
        CommunicatorConfig communicatorConfig = this.communicator.getCommunicatorConfig();
        if (StringUtils.isNotEmpty(communicatorConfig.getSetDivision()) && communicatorConfig.isEnableSet()) {
            cfg.setSetDivision(communicatorConfig.getSetDivision());
        }
        if (StringUtils.isNotEmpty(setDivision)) {
            cfg.setSetDivision(setDivision);
        }
    }

    private void updateServantEndpoints(ServantProxyConfig cfg) {
        CommunicatorConfig communicatorConfig = this.communicator.getCommunicatorConfig();
        String endpoints = null;
        if (!(ParseTools.hasServerNode(cfg.getObjectName()) || cfg.isDirectConnection() || communicatorConfig.getLocator().startsWith(cfg.getSimpleObjectName()))) {
            try {
                endpoints = RegisterManager.getInstance().getHandler() != null ? ParseTools.parse(RegisterManager.getInstance().getHandler().query(cfg.getSimpleObjectName()), cfg.getSimpleObjectName()) : this.communicator.getQueryHelper().getServerNodes(cfg);
                if (StringUtils.isEmpty(endpoints)) {
                    throw new CommunicatorConfigException(cfg.getSimpleObjectName(), "servant node is empty on get by registry! communicator id=" + this.communicator.getId());
                }
                ServantCacheManager.getInstance().save(this.communicator.getId(), cfg.getSimpleObjectName(), endpoints, communicatorConfig.getDataPath());
            }
            catch (CommunicatorConfigException e) {
                endpoints = ServantCacheManager.getInstance().get(this.communicator.getId(), cfg.getSimpleObjectName(), communicatorConfig.getDataPath());
                logger.error(cfg.getSimpleObjectName() + " error occurred on get by registry, use by local cache=" + endpoints + "|" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (StringUtils.isEmpty(endpoints)) {
                throw new CommunicatorConfigException(cfg.getSimpleObjectName(), "error occurred on create proxy, servant endpoint is empty! locator =" + communicatorConfig.getLocator() + "|communicator id=" + this.communicator.getId());
            }
            cfg.setObjectName(endpoints);
        }
        if (StringUtils.isEmpty(cfg.getObjectName())) {
            throw new CommunicatorConfigException(cfg.getSimpleObjectName(), "error occurred on create proxy, servant endpoint is empty!");
        }
    }
}

