/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.loadbalance;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.cluster.ServantInvokerAliveStat;
import com.qq.tars.client.rpc.InvokerComparator;
import com.qq.tars.client.rpc.loadbalance.LoadBalanceHelper;
import com.qq.tars.common.util.CollectionUtils;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.exc.NoInvokerException;
import com.qq.tars.support.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class RoundRobinLoadBalance<T>
implements LoadBalance<T> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final AtomicInteger sequence = new AtomicInteger();
    private final AtomicInteger staticWeightSequence = new AtomicInteger();
    private final ServantProxyConfig config;
    private final InvokerComparator comparator = new InvokerComparator();
    private volatile List<Invoker<T>> sortedInvokersCache = null;
    private volatile List<Invoker<T>> staticWeightInvokersCache = null;

    public RoundRobinLoadBalance(ServantProxyConfig config) {
        this.config = config;
    }

    @Override
    public Invoker<T> select(InvokeContext invocation) throws NoInvokerException {
        List<Invoker<T>> sortedInvokers;
        List<Invoker<T>> staticWeightInvokers = this.staticWeightInvokersCache;
        if (staticWeightInvokers != null && !staticWeightInvokers.isEmpty()) {
            Invoker<T> invoker = staticWeightInvokers.get((this.staticWeightSequence.getAndIncrement() & Integer.MAX_VALUE) % staticWeightInvokers.size());
            if (invoker.isAvailable()) {
                return invoker;
            }
            ServantInvokerAliveStat stat = ServantInvokerAliveChecker.get(invoker.getUrl());
            if (stat.isAlive() || stat.getLastRetryTime() + (long)(this.config.getTryTimeInterval() * 1000) < System.currentTimeMillis()) {
                logger.info("try to use inactive invoker|" + invoker.getUrl().toIdentityString());
                stat.setLastRetryTime(System.currentTimeMillis());
                return invoker;
            }
        }
        if (CollectionUtils.isEmpty(sortedInvokers = this.sortedInvokersCache)) {
            throw new NoInvokerException("no such active connection invoker");
        }
        ArrayList<Invoker<T>> list = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : sortedInvokers) {
            if (!invoker.isAvailable()) {
                ServantInvokerAliveStat stat = ServantInvokerAliveChecker.get(invoker.getUrl());
                if (!stat.isAlive() && stat.getLastRetryTime() + (long)(this.config.getTryTimeInterval() * 1000) >= System.currentTimeMillis()) continue;
                list.add(invoker);
                continue;
            }
            list.add(invoker);
        }
        if (list.isEmpty()) {
            throw new NoInvokerException(this.config.getSimpleObjectName() + " try to select active invoker, size=" + sortedInvokers.size() + ", no such active connection invoker");
        }
        Invoker invoker = (Invoker)list.get((this.sequence.getAndIncrement() & Integer.MAX_VALUE) % list.size());
        if (!invoker.isAvailable()) {
            logger.info("try to use inactive invoker|" + invoker.getUrl().toIdentityString());
            ServantInvokerAliveChecker.get(invoker.getUrl()).setLastRetryTime(System.currentTimeMillis());
        }
        return invoker;
    }

    @Override
    public void refresh(Collection<Invoker<T>> invokers) {
        logger.info("{} try to refresh RoundRobinLoadBalance's invoker cache, size= {} ", (Object)this.config.getSimpleObjectName(), (Object)(CollectionUtils.isEmpty(invokers) ? 0 : invokers.size()));
        if (CollectionUtils.isEmpty(invokers)) {
            this.sortedInvokersCache = null;
            this.staticWeightInvokersCache = null;
            return;
        }
        ArrayList<Invoker<T>> sortedInvokersTmp = new ArrayList<Invoker<T>>(invokers);
        Collections.sort(sortedInvokersTmp, this.comparator);
        this.sortedInvokersCache = sortedInvokersTmp;
        this.staticWeightInvokersCache = LoadBalanceHelper.buildStaticWeightList(sortedInvokersTmp, this.config);
        logger.info("{} refresh RoundRobinLoadBalance's invoker cache done, staticWeightInvokersCache size= {}, sortedInvokersCache size={}", new Object[]{this.config.getSimpleObjectName(), this.staticWeightInvokersCache == null || this.staticWeightInvokersCache.isEmpty() ? 0 : this.staticWeightInvokersCache.size(), this.sortedInvokersCache == null || this.sortedInvokersCache.isEmpty() ? 0 : this.sortedInvokersCache.size()});
    }
}

