/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common.util;

import java.util.Collection;
import java.util.Map;

public class CommonUtils {
    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("instance Class: " + clazz.getName() + " with ex: " + e.getMessage(), e);
        }
    }

    public static <T> T newInstance(String className) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("instance Class: " + className + " with ex: " + e.getMessage(), e);
        }
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException("forName Class: " + className + " with ex: " + e.getMessage(), e);
        }
    }

    public static boolean isEmpty(String input) {
        return null == input || input.trim().isEmpty();
    }

    public static boolean isEmptyArray(Object[] array) {
        return null == array || array.length == 0;
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isJavaBase(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == String.class;
    }

    public static int getPoolSize() {
        int processors = Runtime.getRuntime().availableProcessors();
        return processors > 8 ? 4 + processors * 5 / 8 : processors + 1;
    }
}

