/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.exc;

import com.qq.tars.rpc.exc.ServerDecodeException;
import com.qq.tars.rpc.exc.ServerEncodeException;
import com.qq.tars.rpc.exc.ServerImpException;
import com.qq.tars.rpc.exc.ServerNoFuncException;
import com.qq.tars.rpc.exc.ServerNoServantException;
import com.qq.tars.rpc.exc.ServerOverloadException;
import com.qq.tars.rpc.exc.ServerQueueTimeoutException;
import com.qq.tars.rpc.exc.ServerResetGridException;
import com.qq.tars.rpc.exc.ServerUnknownException;
import com.qq.tars.rpc.exc.TarsException;

public class ServerException
extends TarsException {
    private static final long serialVersionUID = 5930969532642083140L;
    private int ret;

    public ServerException(int ret) {
        super("server error code " + ret);
        this.ret = ret;
    }

    public ServerException(int ret, String message) {
        super("server error code " + ret + "|" + message);
        this.ret = ret;
    }

    public int getRet() {
        return this.ret;
    }

    public static TarsException makeException(int ret) {
        return ServerException.makeException(ret, "");
    }

    public static TarsException makeException(int ret, String message) {
        if (ret == -1) {
            return new ServerDecodeException(ret, message);
        }
        if (ret == -2) {
            return new ServerEncodeException(ret, message);
        }
        if (ret == -3) {
            return new ServerNoFuncException(ret, message);
        }
        if (ret == -4) {
            return new ServerNoServantException(ret, message);
        }
        if (ret == -6) {
            return new ServerQueueTimeoutException(ret, message);
        }
        if (ret == -5) {
            return new ServerResetGridException(ret, message);
        }
        if (ret == -9) {
            return new ServerOverloadException(ret, message);
        }
        if (ret == -10) {
            return new ServerImpException(ret, message);
        }
        return new ServerUnknownException(ret, message);
    }
}

