/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.apps;

import com.qq.tars.common.Filter;
import com.qq.tars.common.FilterKind;
import com.qq.tars.rpc.protocol.ext.ExtendedServant;
import com.qq.tars.rpc.protocol.tars.support.AnalystManager;
import com.qq.tars.server.apps.DefaultAppContextEvent;
import com.qq.tars.server.apps.DefaultAppServantEvent;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.Adapter;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextListener;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.server.core.AppService;
import com.qq.tars.server.core.ServantAdapter;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.support.admin.AdminFServant;
import com.qq.tars.support.admin.impl.AdminFServantImpl;
import com.qq.tars.support.trace.TraceCallbackFilter;
import com.qq.tars.support.trace.TraceClientFilter;
import com.qq.tars.support.trace.TraceServerFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseAppContext
implements AppContext {
    boolean ready = true;
    ConcurrentHashMap<String, ServantHomeSkeleton> skeletonMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Adapter> servantAdapterMap = new ConcurrentHashMap();
    HashMap<String, String> contextParams = new HashMap();
    Set<AppContextListener> listeners = new HashSet<AppContextListener>(4);
    Map<FilterKind, List<Filter>> filters = new HashMap<FilterKind, List<Filter>>();

    BaseAppContext() {
        this.filters.put(FilterKind.SERVER, new LinkedList());
        this.filters.put(FilterKind.CLIENT, new LinkedList());
        this.filters.put(FilterKind.CALLBACK, new LinkedList());
    }

    @Override
    public void init() {
        try {
            this.loadServants();
            this.injectAdminServant();
            this.initServants();
            this.appContextStarted();
            System.out.println("[SERVER] The application started successfully.");
        }
        catch (Exception ex) {
            this.ready = false;
            ex.printStackTrace();
            System.out.println("[SERVER] failed to start the application.");
        }
    }

    protected abstract void loadServants() throws Exception;

    @Override
    public void stop() {
        for (Adapter servantAdapter : this.servantAdapterMap.values()) {
            servantAdapter.stop();
        }
    }

    void injectAdminServant() {
        try {
            String skeletonName = "AdminObj";
            ServantHomeSkeleton skeleton = new ServantHomeSkeleton(skeletonName, new AdminFServantImpl(), AdminFServant.class, null, null, -1);
            skeleton.setAppContext(this);
            ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
            ServantAdapterConfig config = serverCfg.getServantAdapterConfMap().get("AdminObj");
            ServantAdapter servantAdapter = new ServantAdapter(config);
            servantAdapter.bind(skeleton);
            this.servantAdapterMap.put(skeletonName, servantAdapter);
            this.skeletonMap.put(skeletonName, skeleton);
        }
        catch (Exception e) {
            System.err.println("init om service failed:context=[]");
            e.printStackTrace();
        }
    }

    void appServantStarted(AppService appService) {
        for (AppContextListener listener : this.listeners) {
            listener.appServantStarted(new DefaultAppServantEvent(appService));
        }
    }

    void initServants() {
        for (String skeletonName : this.skeletonMap.keySet()) {
            ServantHomeSkeleton skeleton = this.skeletonMap.get(skeletonName);
            Class<ExtendedServant> api = skeleton.getApiClass();
            try {
                if (api.isAssignableFrom(ExtendedServant.class)) continue;
                AnalystManager.getInstance().registry(this.name(), api, skeleton.name());
            }
            catch (Exception e) {
                System.err.println("app[] init servant[" + api.getName() + "] failed");
                e.printStackTrace();
            }
        }
    }

    void loadDefaultFilter() {
        List<Filter> serverFilters = this.filters.get((Object)FilterKind.SERVER);
        TraceServerFilter traceServerFilter = new TraceServerFilter();
        traceServerFilter.init();
        serverFilters.add(traceServerFilter);
        List<Filter> clientFilters = this.filters.get((Object)FilterKind.CLIENT);
        TraceClientFilter traceClientFilter = new TraceClientFilter();
        traceClientFilter.init();
        clientFilters.add(traceClientFilter);
        List<Filter> callbackFilters = this.filters.get((Object)FilterKind.CALLBACK);
        TraceCallbackFilter traceCallbackFilter = new TraceCallbackFilter();
        traceCallbackFilter.init();
        callbackFilters.add(traceCallbackFilter);
    }

    void appContextStarted() {
        for (AppContextListener listener : this.listeners) {
            listener.appContextStarted(new DefaultAppContextEvent(this));
        }
    }

    void setAppContext() {
        AppContextManager.getInstance().setAppContext(this);
    }

    @Override
    public String name() {
        return "";
    }

    @Override
    public ServantHomeSkeleton getCapHomeSkeleton(String homeName) {
        if (!this.ready) {
            throw new RuntimeException("The application isn't started.");
        }
        return this.skeletonMap.get(homeName);
    }

    @Override
    public List<Filter> getFilters(FilterKind kind) {
        if (!this.ready) {
            throw new RuntimeException("The application isn't started.");
        }
        return this.filters.get((Object)kind);
    }

    @Override
    public void addFilter(FilterKind kind, Filter filter) {
        List<Filter> filters = this.filters.get((Object)kind);
        filters.add(filter);
    }
}

