/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.common.support.Endpoint;
import com.qq.tars.net.core.Processor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.protocol.ProtocolFactory;
import com.qq.tars.net.util.Utils;
import com.qq.tars.protocol.annotation.ServantCodec;
import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.rpc.protocol.Codec;
import com.qq.tars.rpc.protocol.ServantProtocolFactory;
import com.qq.tars.rpc.protocol.tars.TarsCodec;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.Adapter;
import com.qq.tars.server.core.AppService;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.server.core.ServantThreadPoolManager;
import com.qq.tars.server.core.TarsServantProcessor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;

public class ServantAdapter
implements Adapter {
    private SelectorManager selectorManager = null;
    private final ServantAdapterConfig servantAdapterConfig;
    private ServantHomeSkeleton skeleton;

    public ServantAdapter(ServantAdapterConfig servantAdapterConfig) {
        this.servantAdapterConfig = servantAdapterConfig;
    }

    public void bind() throws IOException {
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        boolean keepAlive = true;
        TarsCodec codec = new TarsCodec(serverCfg.getCharsetName());
        TarsServantProcessor processor = new TarsServantProcessor();
        Executor threadPool = ServantThreadPoolManager.get(this.servantAdapterConfig);
        Endpoint endpoint = this.servantAdapterConfig.getEndpoint();
        if (endpoint.type().equals("tcp")) {
            this.selectorManager = new SelectorManager(Utils.getSelectorPoolSize(), (ProtocolFactory)new ServantProtocolFactory(codec), threadPool, (Processor)processor, keepAlive, "server-tcp-reactor", false);
            this.selectorManager.setTcpNoDelay(serverCfg.isTcpNoDelay());
            this.selectorManager.start();
            System.out.println("[SERVER] server starting at " + endpoint + "...");
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.socket().bind(new InetSocketAddress(endpoint.host(), endpoint.port()), 1024);
            serverChannel.configureBlocking(false);
            this.selectorManager.getReactor(0).registerChannel((SelectableChannel)serverChannel, 16);
            System.out.println("[SERVER] server started at " + endpoint + "...");
        } else if (endpoint.type().equals("udp")) {
            this.selectorManager = new SelectorManager(1, (ProtocolFactory)new ServantProtocolFactory(codec), threadPool, (Processor)processor, false, "server-udp-reactor", true);
            this.selectorManager.start();
            System.out.println("[SERVER] server starting at " + endpoint + "...");
            DatagramChannel serverChannel = DatagramChannel.open();
            DatagramSocket socket = serverChannel.socket();
            socket.bind(new InetSocketAddress(endpoint.host(), endpoint.port()));
            serverChannel.configureBlocking(false);
            this.selectorManager.getReactor(0).registerChannel((SelectableChannel)serverChannel, 1);
            System.out.println("[SERVER] servant started at " + endpoint + "...");
        }
    }

    @Override
    public void bind(AppService appService) throws IOException {
        this.skeleton = (ServantHomeSkeleton)appService;
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        boolean keepAlive = true;
        Codec codec = this.createCodec(serverCfg);
        Processor processor = this.createProcessor(serverCfg);
        Executor threadPool = ServantThreadPoolManager.get(this.servantAdapterConfig);
        Endpoint endpoint = this.servantAdapterConfig.getEndpoint();
        if (endpoint.type().equals("tcp")) {
            this.selectorManager = new SelectorManager(Utils.getSelectorPoolSize(), (ProtocolFactory)new ServantProtocolFactory(codec), threadPool, processor, keepAlive, "server-tcp-reactor", false);
            this.selectorManager.setTcpNoDelay(serverCfg.isTcpNoDelay());
            this.selectorManager.start();
            System.out.println("[SERVER] server starting at " + endpoint + "...");
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.socket().bind(new InetSocketAddress(endpoint.host(), endpoint.port()), 1024);
            serverChannel.configureBlocking(false);
            this.selectorManager.getReactor(0).registerChannel((SelectableChannel)serverChannel, 16);
            System.out.println("[SERVER] server started at " + endpoint + "...");
        } else if (endpoint.type().equals("udp")) {
            this.selectorManager = new SelectorManager(1, (ProtocolFactory)new ServantProtocolFactory(codec), threadPool, processor, false, "server-udp-reactor", true);
            this.selectorManager.start();
            System.out.println("[SERVER] server starting at " + endpoint + "...");
            DatagramChannel serverChannel = DatagramChannel.open();
            DatagramSocket socket = serverChannel.socket();
            socket.bind(new InetSocketAddress(endpoint.host(), endpoint.port()));
            serverChannel.configureBlocking(false);
            this.selectorManager.getReactor(0).registerChannel((SelectableChannel)serverChannel, 1);
            System.out.println("[SERVER] servant started at " + endpoint + "...");
        }
    }

    public ServantAdapterConfig getServantAdapterConfig() {
        return this.servantAdapterConfig;
    }

    public ServantHomeSkeleton getSkeleton() {
        return this.skeleton;
    }

    private Processor createProcessor(ServerConfig serverCfg) throws TarsException {
        Processor processor = null;
        Class<? extends Processor> processorClass = this.skeleton.getProcessorClass();
        if (processorClass == null) {
            return new TarsServantProcessor();
        }
        if (processorClass != null) {
            try {
                Constructor<? extends Processor> constructor = processorClass.getConstructor(ServantAdapter.class);
                processor = constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new TarsException("error occurred on create codec, codec=" + processorClass.getName());
            }
        }
        return processor;
    }

    private Codec createCodec(ServerConfig serverCfg) throws TarsException {
        ServantCodec servantCodec;
        Codec codec = null;
        Class<? extends Codec> codecClass = this.skeleton.getCodecClass();
        if (codecClass == null && (servantCodec = this.skeleton.getApiClass().getAnnotation(ServantCodec.class)) != null) {
            codecClass = servantCodec.codec();
        }
        if (codecClass == null) {
            codecClass = TarsCodec.class;
        }
        if (codecClass != null) {
            try {
                Constructor<? extends Codec> constructor = codecClass.getConstructor(String.class);
                codec = constructor.newInstance(serverCfg.getCharsetName());
            }
            catch (Exception e) {
                throw new TarsException("error occurred on create codec, codec=" + codecClass.getName());
            }
        }
        return codec;
    }

    @Override
    public void stop() {
        if (this.selectorManager != null) {
            this.selectorManager.stop();
        }
    }
}

