/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.common.util.concurrent.TaskQueue;
import com.qq.tars.common.util.concurrent.TaskThreadFactory;
import com.qq.tars.common.util.concurrent.TaskThreadPoolExecutor;
import com.qq.tars.server.config.ServantAdapterConfig;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class ServantThreadPoolManager {
    private static final HashMap<String, Executor> threadExecutors = new HashMap();

    public static Executor get(ServantAdapterConfig config) {
        return ServantThreadPoolManager.getAndCreateExecutor(config);
    }

    private static synchronized Executor createDefaultExecutor(String key) {
        Executor executor = threadExecutors.get(null);
        if (executor != null) {
            threadExecutors.put(key, executor);
            return executor;
        }
        TaskQueue taskqueue = new TaskQueue(20000);
        TaskThreadPoolExecutor pool = new TaskThreadPoolExecutor(5, 512, 120L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, new TaskThreadFactory("ServantThreadPool-exec-"));
        taskqueue.setParent(pool);
        threadExecutors.put(null, pool);
        threadExecutors.put(key, pool);
        return pool;
    }

    private static synchronized Executor getAndCreateExecutor(ServantAdapterConfig config) {
        String key = config.getHandleGroup();
        Executor executor = null;
        executor = threadExecutors.get(key);
        if (executor != null) {
            return executor;
        }
        int minPoolSize = -1;
        int maxPoolSize = -1;
        int queueSize = -1;
        minPoolSize = config.getThreads();
        maxPoolSize = config.getThreads();
        queueSize = config.getQueueCap();
        if (minPoolSize < 0 || maxPoolSize < 0 || queueSize < 0) {
            return ServantThreadPoolManager.createDefaultExecutor(key);
        }
        TaskQueue taskqueue = new TaskQueue(queueSize);
        TaskThreadPoolExecutor pool = new TaskThreadPoolExecutor(minPoolSize, maxPoolSize, 120L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, new TaskThreadFactory("ServantThreadPool-exec-" + key + '-'));
        taskqueue.setParent(pool);
        threadExecutors.put(key, pool);
        return pool;
    }
}

