/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.admin;

import com.qq.tars.common.util.StringUtils;
import com.qq.tars.support.admin.CommandHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CustomCommandHelper {
    private static final CustomCommandHelper Instance = new CustomCommandHelper();
    private Map<String, CommandHandler> customHandlerMap = new ConcurrentHashMap<String, CommandHandler>();

    private CustomCommandHelper() {
    }

    public static CustomCommandHelper getInstance() {
        return Instance;
    }

    public boolean registerCustomHandler(String cmdName, CommandHandler handler) {
        if (StringUtils.isEmpty(cmdName) || handler == null) {
            return false;
        }
        this.customHandlerMap.put(cmdName, handler);
        return true;
    }

    public CommandHandler getCommandHandler(String cmdName) {
        return this.customHandlerMap.get(cmdName);
    }
}

