/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.stat;

import com.qq.tars.support.stat.ProxyStat;
import com.qq.tars.support.stat.ProxyStatBody;
import com.qq.tars.support.stat.ProxyStatHead;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class InvokeStatHelper {
    private static final InvokeStatHelper instance = new InvokeStatHelper();
    private volatile ConcurrentHashMap<String, ProxyStat> proxyStats = new ConcurrentHashMap();
    private volatile CopyOnWriteArrayList<Integer> timeStatInterval = new CopyOnWriteArrayList();

    private InvokeStatHelper() {
        this.timeStatInterval.addAll(ProxyStat.DEFAULT_TIME_STAT_INTERVAL);
    }

    public static InvokeStatHelper getInstance() {
        return instance;
    }

    public CopyOnWriteArrayList<Integer> getStatIntervals() {
        return this.timeStatInterval;
    }

    public ProxyStat addProxyStat(String objectName) {
        ProxyStat statTool = this.proxyStats.get(objectName);
        if (statTool == null) {
            this.proxyStats.putIfAbsent(objectName, new ProxyStat());
        }
        return this.proxyStats.get(objectName);
    }

    public ProxyStat getProxyStat(String objectName) {
        ProxyStat tool = this.proxyStats.get(objectName);
        if (tool == null) {
            tool = this.addProxyStat(objectName);
        }
        return tool;
    }

    public ConcurrentHashMap<String, ProxyStat> getProxyStats() {
        return this.proxyStats;
    }

    public void setTimeStatInterval() {
        for (Map.Entry<String, ProxyStat> entry : this.proxyStats.entrySet()) {
            this.setTimeStatInterval(entry.getKey());
        }
    }

    public void setTimeStatInterval(String objectName) {
        for (Map.Entry<ProxyStatHead, ProxyStatBody> entry : this.getProxyStat(objectName).getStats().entrySet()) {
            entry.getValue().setTimeStatInterval(this.timeStatInterval);
        }
    }

    public void resetTimeStatInterval() {
        this.timeStatInterval.clear();
        this.timeStatInterval.addAll(ProxyStat.DEFAULT_TIME_STAT_INTERVAL);
        this.setTimeStatInterval();
    }

    public void addTimeStatInterval(int interval) {
        boolean add = false;
        for (int i = 0; i < this.timeStatInterval.size(); ++i) {
            if (interval == this.timeStatInterval.get(i)) {
                return;
            }
            if (interval >= this.timeStatInterval.get(i)) continue;
            this.timeStatInterval.add(i, interval);
            add = true;
            break;
        }
        if (!add) {
            this.timeStatInterval.add(interval);
        }
        this.setTimeStatInterval();
    }
}

