/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.http;

import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpConnection {
    private OkHttpClient client;

    public HttpConnection(Integer connTimeout, Integer readTimeout, Integer writeTimeout) {
        this.client = new OkHttpClient.Builder().connectTimeout((long)connTimeout.intValue(), TimeUnit.SECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)writeTimeout.intValue(), TimeUnit.SECONDS).build();
    }

    public void addInterceptors(Interceptor interceptor) {
        this.client = this.client.newBuilder().addInterceptor(interceptor).build();
    }

    public void setProxy(Proxy proxy) {
        this.client = this.client.newBuilder().proxy(proxy).build();
    }

    public void setProxyAuthenticator(Authenticator authenticator) {
        this.client = this.client.newBuilder().proxyAuthenticator(authenticator).build();
    }

    public Response doRequest(Request request) throws TencentCloudSDKException {
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return response;
    }

    public Response getRequest(String url) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response getRequest(String url, Headers headers) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).headers(headers).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, String body) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (String)body)).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, String body, Headers headers) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse((String)headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (String)body)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, byte[] body, Headers headers) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse((String)headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (byte[])body)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }
}

