/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.collection.CollectionUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequest;
import com.tencent.asr.model.AsrRequestContent;
import com.tencent.asr.model.AsrResponse;
import com.tencent.asr.model.SpeechRecognitionResponse;
import com.tencent.asr.model.SpeechRecognitionResponseResult;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.service.HttpClientService;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognitionSignService;
import com.tencent.asr.service.TractionManager;
import com.tencent.asr.utils.AsrUtils;
import com.tencent.core.handler.BaseEventListener;
import com.tencent.core.handler.RealTimeEventListener;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.ByteUtils;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.utils.Tutils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.conn.ConnectionShutdownException;

public class HttpBaseService {
    protected AsrConfig asrConfig;
    protected AsrRequest asrRequest;
    protected RealTimeEventListener realTimeEventListener;
    protected SpeechRecognitionListener speechRecognitionListener;
    protected String streamId;
    protected TractionManager tractionManager;
    protected AsrRequestContent staging;
    protected BaseEventListener<AsrResponse> baseEventListeners;
    protected long expireTime = System.currentTimeMillis() + 6000L;
    protected volatile boolean cacheStatus = false;
    protected volatile AtomicBoolean endFlag = new AtomicBoolean(false);
    protected volatile AtomicBoolean finishFlag = new AtomicBoolean(false);
    protected SpeechRecognitionSignService speechRecognitionSignService = new SpeechRecognitionSignService();
    protected HttpClientService httpClientService = HttpClientService.getInstance();
    protected List<String> requestStamps = new CopyOnWriteArrayList<String>();
    protected BlockingQueue<String> resultQueue = new LinkedBlockingQueue<String>();
    protected BlockingQueue<AsrResponse> syncResponseQueue = new LinkedBlockingQueue<AsrResponse>();
    protected ConcurrentHashMap<String, AsrResponse> result = new ConcurrentHashMap();
    protected volatile AtomicInteger surplus = new AtomicInteger(0);
    private byte[] sendData = new byte[0];
    private long sendExpireTime = System.currentTimeMillis() + 5000L;
    private Boolean begin = false;

    public HttpBaseService(String streamId, AsrConfig config, AsrRequest request, RealTimeEventListener realTimeEventListener, BaseEventListener<AsrResponse> baseEventListener) {
        this.streamId = streamId;
        this.asrConfig = config;
        this.asrRequest = this.checkAsrRequest(request);
        this.realTimeEventListener = realTimeEventListener;
        this.baseEventListeners = baseEventListener;
        this.staging = AsrRequestContent.builder().seq(0).end(0).voiceId(AsrUtils.getVoiceId(this.asrConfig.getAppId())).streamId(streamId).build();
        this.tractionManager = new TractionManager(this.asrConfig.getAppId());
    }

    public HttpBaseService(String streamId, AsrConfig config, AsrRequest request, SpeechRecognitionListener speechRecognitionListener) {
        this.streamId = streamId;
        this.asrConfig = config;
        this.asrRequest = this.checkAsrRequest(request);
        this.speechRecognitionListener = speechRecognitionListener;
        this.staging = AsrRequestContent.builder().seq(0).end(0).voiceId(AsrUtils.getVoiceId(this.asrConfig.getAppId())).streamId(streamId).build();
        this.tractionManager = new TractionManager(this.asrConfig.getAppId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(byte[] data, boolean end) {
        if (data == null) {
            return;
        }
        if (data.length == 0 && !end) {
            return;
        }
        if (data.length == 2 && end && this.staging.getSeq() == 0) {
            ReportService.ifLogMessage(this.staging.getVoiceId(), "send end null package", false);
            AsrRequestContent content = AsrRequestContent.builder().voiceId(this.staging.getVoiceId()).seq(0).end(1).streamId(this.staging.getStreamId()).costTime(System.currentTimeMillis()).build();
            String stamp = content.getStreamId() + "_asr_" + content.getVoiceId() + "_" + content.getSeq();
            this.requestStamps.add(stamp);
            this.processFinally(null, null, stamp, "", this.asrRequest, content);
            return;
        }
        if (this.staging.getSeq() != 0 && (System.currentTimeMillis() > this.expireTime || this.cacheStatus)) {
            HttpBaseService content = this;
            synchronized (content) {
                this.cacheStatus = false;
                this.expireTime = System.currentTimeMillis() + this.asrConfig.getWaitTime();
                ReportService.ifLogMessage(this.staging.getVoiceId(), "Retransmission settings:" + JsonUtil.toJson(this.staging), true);
                this.staging.setVoiceId(AsrUtils.getVoiceId(this.asrConfig.getAppId()));
                this.staging.setEnd(0);
                this.staging.setSeq(0);
            }
        }
        this.expireTime = System.currentTimeMillis() + this.asrConfig.getWaitTime();
        ReportService.ifLogMessage(this.staging.getVoiceId(), "read data length:" + data.length, false);
        String stamp = this.dispatcherRequest(data, end);
        this.requestStamps.add(stamp);
    }

    protected String dispatcherRequest(byte[] bytes, Boolean endFlag) {
        AsrRequestContent temp = this.staging;
        int end = endFlag != false ? 1 : 0;
        AsrRequestContent content = AsrRequestContent.builder().voiceId(temp.getVoiceId()).seq(temp.getSeq()).end(end).bytes(bytes).streamId(temp.getStreamId()).costTime(System.currentTimeMillis()).build();
        String stamp = this.speechRec(content);
        temp.setSeq(temp.getSeq() + 1);
        temp.setEnd(end);
        return stamp;
    }

    private String speechRec(AsrRequestContent content) {
        this.asrRequest.setTimestamp(System.currentTimeMillis() / 1000L);
        this.asrRequest.setExpired(System.currentTimeMillis() / 1000L + 86400L);
        String stamp = content.getStreamId() + "_asr_" + content.getVoiceId() + "_" + content.getSeq();
        String url = this.speechRecognitionSignService.signUrl(this.asrConfig, this.asrRequest, content);
        String sign = SignBuilder.createPostSign(url, this.asrConfig.getSecretKey(), this.asrRequest);
        AsrRequest tempRequest = JsonUtil.fromJson(JsonUtil.toJson(this.asrRequest), AsrRequest.class);
        this.httpClientRequest(content, stamp, url, sign, tempRequest);
        return stamp;
    }

    private void httpClientRequest(AsrRequestContent content, String stamp, String url, String sign, AsrRequest tempRequest) {
        this.surplus.incrementAndGet();
        if (SpeechRecognitionSysConfig.ifSyncHttp) {
            this.syncRecRequest(this.asrConfig, content, stamp, url, sign, tempRequest);
            return;
        }
        this.asyncRecRequest(this.asrConfig, content, stamp, url, sign, tempRequest);
    }

    private void asyncRecRequest(final AsrConfig config, final AsrRequestContent content, final String stamp, final String url, final String sign, final AsrRequest tempRequest) {
        this.httpClientService.asrAsyncHttp(stamp, sign, url, config.getToken(), content, new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                AsrResponse asrResponse = null;
                try {
                    asrResponse = HttpBaseService.this.parseRecResponse(httpResponse, stamp);
                }
                finally {
                    HttpBaseService.this.processFinally(asrResponse, null, stamp, url, tempRequest, content);
                    HttpBaseService.this.surplus.decrementAndGet();
                }
            }

            public void failed(Exception e) {
                ReportService.ifLogMessage(content.getVoiceId(), "FutureCallback_failed" + Tutils.getStackTraceAsString(e), true);
                AsrResponse asrResponse = null;
                try {
                    asrResponse = HttpBaseService.this.processException(e, stamp, sign, url, content, tempRequest, config);
                }
                catch (Throwable throwable) {
                    HttpBaseService.this.processFinally(asrResponse, e, stamp, url, tempRequest, content);
                    HttpBaseService.this.surplus.decrementAndGet();
                    throw throwable;
                }
                HttpBaseService.this.processFinally(asrResponse, e, stamp, url, tempRequest, content);
                HttpBaseService.this.surplus.decrementAndGet();
            }

            public void cancelled() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRecRequest(AsrConfig config, AsrRequestContent content, String stamp, String url, String sign, AsrRequest tempRequest) {
        AsrResponse asrResponse = null;
        try {
            CloseableHttpResponse response = this.httpClientService.syncHttp(stamp, sign, url, config.getToken(), content);
            asrResponse = this.parseRecResponse((HttpResponse)response, stamp);
            this.processFinally(asrResponse, null, stamp, url, tempRequest, content);
            this.surplus.decrementAndGet();
        }
        catch (Exception e) {
            try {
                asrResponse = this.processException(e, stamp, sign, url, content, tempRequest, config);
                this.processFinally(asrResponse, null, stamp, url, tempRequest, content);
                this.surplus.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.processFinally(asrResponse, null, stamp, url, tempRequest, content);
                this.surplus.decrementAndGet();
                throw throwable;
            }
        }
    }

    private AsrResponse createExceptionResponse(AsrRequestContent content, String stamp, Exception e) {
        AsrResponse asrResponse = new AsrResponse();
        if (e instanceof IOException) {
            asrResponse.setCode(AsrConstant.Code.IO_EXCEPTION.getCode());
        } else {
            asrResponse.setCode(AsrConstant.Code.EXCEPTION.getCode());
        }
        asrResponse.setStreamId(content.getStreamId());
        asrResponse.setStamp(stamp);
        asrResponse.setVoiceId(content.getVoiceId());
        asrResponse.setSeq(content.getSeq());
        asrResponse.setFinalSpeech(content.getEnd());
        asrResponse.setMessage(Tutils.getStackTraceAsString(e));
        return asrResponse;
    }

    private void processFinally(AsrResponse asrResponse, Exception e, String stamp, String url, AsrRequest tempRequest, AsrRequestContent content) {
        content.setCostTime(System.currentTimeMillis() - content.getCostTime());
        if (asrResponse == null && content.getEnd() == 1) {
            asrResponse = new AsrResponse();
            asrResponse.setStamp(stamp);
            asrResponse.setVoiceId(content.getVoiceId());
            asrResponse.setSeq(content.getSeq());
            asrResponse.setFinalSpeech(content.getEnd());
            asrResponse.setMessage("success");
            asrResponse.setCode(AsrConstant.Code.SUCCESS.getCode());
        }
        if (asrResponse != null) {
            if (asrResponse.getFinalSpeech() == null) {
                asrResponse.setFinalSpeech(content.getEnd());
            }
            boolean isCommonError = e instanceof SocketTimeoutException || e instanceof ConnectionShutdownException || e instanceof ConnectionClosedException;
            ReportService.report(asrResponse.getCode() == 0, String.valueOf(asrResponse.getCode()), this.asrConfig, this.streamId, tempRequest, asrResponse, url, asrResponse.getMessage(), content.getCostTime());
            if (isCommonError) {
                asrResponse.setCode(0);
                asrResponse.setMessage("success");
            }
            if (SpeechRecognitionSysConfig.ifSyncHttp) {
                this.syncResponseQueue.add(asrResponse);
            } else {
                this.resultQueue.add(stamp);
                this.result.put(asrResponse.getStamp(), asrResponse);
            }
            if (AsrConstant.Code.ifInRetryCode(asrResponse.getCode()) && asrResponse.getVoiceId() != null && this.staging.getVoiceId().equals(asrResponse.getVoiceId())) {
                this.cacheStatus = true;
            }
            if (this.baseEventListeners != null) {
                if (asrResponse.getCode() == AsrConstant.Code.SUCCESS.getCode().intValue()) {
                    this.baseEventListeners.success(asrResponse);
                } else if (e != null) {
                    if (!isCommonError) {
                        this.baseEventListeners.fail(asrResponse, e);
                    }
                } else if (!AsrConstant.Code.ifInRetryCode(asrResponse.getCode())) {
                    this.baseEventListeners.success(asrResponse);
                }
            }
        }
    }

    private void returnResult(AsrResponse asrResponse) {
        if (asrResponse != null) {
            if (asrResponse.getCode() == AsrConstant.Code.SUCCESS.getCode().intValue()) {
                if (this.realTimeEventListener != null) {
                    this.realTimeEventListener.translation(asrResponse);
                }
                this.speechRecognitionListenerCallBack(asrResponse);
            } else if (!AsrConstant.Code.ifInRetryCode(asrResponse.getCode())) {
                if (this.realTimeEventListener != null) {
                    this.realTimeEventListener.translation(asrResponse);
                }
                this.speechRecognitionListenerCallBack(asrResponse);
            }
        }
    }

    private AsrResponse retryRecRequest(String stamp, String sign, String url, AsrRequestContent content) {
        for (int retry = 0; retry < SpeechRecognitionSysConfig.retryRequestNum; ++retry) {
            ReportService.ifLogMessage(stamp, "retry send request:" + retry, false);
            try {
                CloseableHttpResponse httpResponse = this.httpClientService.syncHttp(stamp, sign, url, this.asrConfig.getToken(), content);
                AsrResponse asrResponse = this.parseRecResponse((HttpResponse)httpResponse, stamp);
                if (asrResponse == null) continue;
                ReportService.ifLogMessage(stamp, "retry send request  success :" + retry, false);
                return asrResponse;
            }
            catch (Exception exception) {
                ReportService.ifLogMessage(stamp, "retry :" + exception.getMessage(), false);
            }
        }
        return null;
    }

    private AsrResponse parseRecResponse(HttpResponse httpResponse, String stamp) {
        if (httpResponse == null) {
            return null;
        }
        String responseStr = this.httpClientService.dealHttpClientResponse(httpResponse, stamp);
        AsrResponse response = null;
        try {
            response = JsonUtil.fromJson(responseStr, AsrResponse.class);
            response.setStreamId(this.streamId);
            response.setStamp(stamp);
        }
        catch (Exception e) {
            response = new AsrResponse();
            response.setStreamId(this.streamId);
            response.setVoiceId(this.staging.getVoiceId());
            response.setStamp(stamp);
            response.setMessage(responseStr);
            response.setCode(AsrConstant.Code.FAIL.getCode());
        }
        return response;
    }

    private AsrRequest checkAsrRequest(AsrRequest request) {
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("please set engine_type");
        }
        if (request.getCutLength() == null) {
            this.resetCutLength(request);
        }
        if (request.getEngineModelType().contains("8k") && (request.getCutLength() <= 0 || request.getCutLength() >= 16000)) {
            request.setCutLength(3200);
        }
        if (request.getEngineModelType().contains("16k") && (request.getCutLength() <= 0 || request.getCutLength() >= 32000)) {
            request.setCutLength(6400);
        }
        return request;
    }

    private void resetCutLength(AsrRequest request) {
        if (request.getEngineModelType().contains("8k")) {
            request.setCutLength(3200);
        }
        if (request.getEngineModelType().contains("16k")) {
            request.setCutLength(6400);
        }
    }

    private AsrResponse processException(Exception e, String stamp, String sign, String url, AsrRequestContent content, AsrRequest tempRequest, AsrConfig config) {
        AsrResponse asrResponse = null;
        if (SpeechRecognitionSysConfig.ifSyncHttp) {
            asrResponse = this.retryRecRequest(stamp, sign, url, content);
        }
        if (!SpeechRecognitionSysConfig.ifSyncHttp && !this.finishFlag.get()) {
            asrResponse = this.retryRecRequest(stamp, sign, url, content);
        }
        if (asrResponse == null) {
            asrResponse = this.createExceptionResponse(content, stamp, e);
            long delayTime = System.currentTimeMillis() - content.getCostTime();
            ReportService.report(false, String.valueOf(AsrConstant.Code.IO_EXCEPTION.getCode()), config, this.streamId, tempRequest, asrResponse, url, asrResponse.getMessage(), delayTime);
            try {
                asrResponse.setMessage(asrResponse.getMessage().substring(0, asrResponse.getMessage().indexOf("\n")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return asrResponse;
    }

    public byte[] createBytes(byte[] data, int size) {
        if (size > 0 && size < this.asrRequest.getCutLength()) {
            data = ByteUtils.subBytes(data, 0, size);
        }
        if (size <= 0) {
            data = new byte[1];
        }
        return data;
    }

    public void startListerResult() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AtomicInteger expireNum = new AtomicInteger(0);
                while (true) {
                    if (SpeechRecognitionSysConfig.ifSyncHttp) {
                        try {
                            AsrResponse response = HttpBaseService.this.syncResponseQueue.poll(SpeechRecognitionSysConfig.waitResultTimeout, TimeUnit.MILLISECONDS);
                            HttpBaseService.this.returnResult(response);
                            if (response == null || response.getFinalSpeech() == null || response.getFinalSpeech() != 1) continue;
                            ReportService.ifLogMessage(response.getStamp(), "final Exit monitoring", false);
                            break;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    try {
                        try {
                            HttpBaseService.this.resultQueue.poll(SpeechRecognitionSysConfig.waitResultTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!HttpBaseService.this.requestStamps.isEmpty() && HttpBaseService.this.result.containsKey(HttpBaseService.this.requestStamps.get(0))) {
                            expireNum.set(0);
                            String stamp = HttpBaseService.this.requestStamps.get(0);
                            AsrResponse response = HttpBaseService.this.result.get(stamp);
                            if (response != null) {
                                HttpBaseService.this.returnResult(response);
                                if (response.getFinalSpeech() != null && response.getFinalSpeech() == 1) {
                                    ReportService.ifLogMessage(response.getStamp(), "final Exit monitoring", false);
                                    break;
                                }
                                HttpBaseService.this.result.remove(stamp);
                                if (!HttpBaseService.this.requestStamps.isEmpty()) {
                                    HttpBaseService.this.requestStamps.remove(0);
                                }
                            }
                        } else {
                            expireNum.incrementAndGet();
                        }
                        if (expireNum.get() > 10 && !HttpBaseService.this.requestStamps.isEmpty()) {
                            HttpBaseService.this.requestStamps.remove(0);
                        }
                        if (!HttpBaseService.this.requestStamps.isEmpty() || !HttpBaseService.this.finishFlag.get() || HttpBaseService.this.surplus.get() > 0) continue;
                        ReportService.ifLogMessage(HttpBaseService.this.staging.getVoiceId(), "Exit monitoring", false);
                    }
                    catch (RuntimeException runtimeException) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    protected void closeClient() {
        if (this.httpClientService != null) {
            this.httpClientService.closeClient();
        }
    }

    protected void sendData(byte[] audio, Boolean end) {
        if (audio == null) {
            return;
        }
        if (!end.booleanValue() || end.booleanValue() && this.sendData.length == 0) {
            this.sendData = ByteUtils.concat(this.sendData, audio);
        }
        if (end.booleanValue()) {
            this.send(this.sendData, true);
            this.sendExpireTime = System.currentTimeMillis() + this.asrConfig.getWaitTime() / 2L;
            return;
        }
        if (this.sendData.length >= this.asrRequest.getCutLength()) {
            int posi = 0;
            while (this.sendData.length - posi >= this.asrRequest.getCutLength()) {
                this.send(ByteUtils.subBytes(this.sendData, posi, this.asrRequest.getCutLength()), false);
                posi += this.asrRequest.getCutLength().intValue();
            }
            this.sendData = ByteUtils.subBytes(this.sendData, posi, this.sendData.length - posi);
            this.sendExpireTime = System.currentTimeMillis() + this.asrConfig.getWaitTime() / 2L;
        }
        if (System.currentTimeMillis() > this.sendExpireTime || this.staging.getSeq() == 0) {
            this.send(this.sendData, false);
            this.sendExpireTime = System.currentTimeMillis() + this.asrConfig.getWaitTime() / 2L;
            this.sendData = new byte[0];
            return;
        }
    }

    private void speechRecognitionListenerCallBack(AsrResponse asrResponse) {
        if (this.speechRecognitionListener == null) {
            return;
        }
        List<SpeechRecognitionResponseResult> resultList = asrResponse.getResultList();
        SpeechRecognitionResponse response = JsonUtil.fromJson(JsonUtil.toJson(asrResponse), SpeechRecognitionResponse.class);
        if (asrResponse != null && asrResponse.getCode() == 0) {
            if (CollectionUtil.isNotEmpty(resultList)) {
                resultList.forEach(item -> {
                    response.setResult((SpeechRecognitionResponseResult)item);
                    if (item.getSliceType() == 0) {
                        this.begin = true;
                        this.speechRecognitionListener.onSentenceBegin(response);
                    } else if (item.getSliceType() == 2) {
                        if (!this.begin.booleanValue() && response.getResult() != null) {
                            SpeechRecognitionResponse beginResp = JsonUtil.fromJson(JsonUtil.toJson(response), SpeechRecognitionResponse.class);
                            beginResp.getResult().setSliceType(0);
                            this.speechRecognitionListener.onSentenceBegin(beginResp);
                        }
                        this.begin = false;
                        this.speechRecognitionListener.onSentenceEnd(response);
                    } else {
                        this.speechRecognitionListener.onRecognitionResultChange(response);
                    }
                });
            }
            if (response.getFinalSpeech() != null && response.getFinalSpeech() == 1) {
                SpeechRecognitionResponse recognitionResponse = new SpeechRecognitionResponse();
                recognitionResponse.setCode(0);
                recognitionResponse.setFinalSpeech(1);
                recognitionResponse.setStreamId(asrResponse.getStreamId());
                recognitionResponse.setVoiceId(asrResponse.getVoiceId());
                recognitionResponse.setMessage("success");
                this.speechRecognitionListener.onRecognitionComplete(recognitionResponse);
            }
        } else {
            this.speechRecognitionListener.onFail(response);
        }
        this.speechRecognitionListener.onMessage(response);
    }

    static class ByteData {
        byte[] data;

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public ByteData() {
        }

        public ByteData(byte[] data) {
            this.data = data;
        }
    }
}

