/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import com.tencent.asr.model.AsrRequestContent;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.core.service.ReportService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientService {
    private static final String STREAM_TYPE = "application/octet-stream";
    private CloseableHttpAsyncClient asyncClient;
    private CloseableHttpClient syncClient;
    private RequestConfig requestConfig = RequestConfig.custom().build();
    private IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(SpeechRecognitionSysConfig.maxRequests.intValue()).setConnectTimeout(SpeechRecognitionSysConfig.connectTimeout).setSoTimeout(SpeechRecognitionSysConfig.socketTimeout).setInterestOpQueued(SpeechRecognitionSysConfig.interestOpQueued).setSoKeepAlive(true).build();
    private PoolingNHttpClientConnectionManager connManager;
    private volatile boolean closed = false;
    private static HttpClientService ins = new HttpClientService();

    public static HttpClientService getInstance() {
        return ins;
    }

    public HttpClientService() {
        DefaultConnectingIOReactor ioReactor = null;
        try {
            ioReactor = new DefaultConnectingIOReactor(this.ioReactorConfig);
        }
        catch (IOReactorException iOReactorException) {
            // empty catch block
        }
        this.connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        this.connManager.setMaxTotal(SpeechRecognitionSysConfig.MaxTotal);
        this.connManager.setDefaultMaxPerRoute(SpeechRecognitionSysConfig.defaultMaxPerRoute);
        this.asyncClient = this.createAsyncHttpClient();
        this.asyncClient.start();
        this.syncClient = this.createSyncHttpClient();
    }

    public void closeClient() {
        try {
            this.closed = true;
            ReportService.ifLogMessage("", "close client", false);
            this.syncClient.close();
            this.asyncClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void asrAsyncHttp(String stamp, String sign, String url, String token, AsrRequestContent item, FutureCallback<HttpResponse> callback) {
        if (!this.closed) {
            ReportService.ifLogMessage(stamp, url, false);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Authorization", sign);
            httpPost.addHeader("Content-Type", STREAM_TYPE);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                httpPost.addHeader("X-TC-Token", token);
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(item.getBytes()));
            Future future = this.asyncClient.execute((HttpUriRequest)httpPost, callback);
        }
    }

    public CloseableHttpResponse syncHttp(String stamp, String sign, String url, String token, AsrRequestContent item) throws IOException {
        if (!this.closed) {
            ReportService.ifLogMessage(stamp, "url:" + url, false);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Authorization", sign);
            httpPost.addHeader("Content-Type", STREAM_TYPE);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                httpPost.addHeader("X-TC-Token", token);
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(item.getBytes()));
            return this.getSyncClient().execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dealHttpClientResponse(HttpResponse httpResponse, String stamp) {
        String responseStr = null;
        try {
            responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            ReportService.ifLogMessage(stamp, responseStr, false);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                ReportService.ifLogMessage(stamp, "ERROR:" + responseStr, true);
            }
        }
        catch (Exception e) {
            ReportService.ifLogMessage(stamp, "Exception:" + e.getMessage() + "_" + responseStr, true);
        }
        finally {
            try {
                InputStream inputStream = httpResponse.getEntity().getContent();
                inputStream.close();
            }
            catch (Exception inputStream) {}
            if (httpResponse instanceof CloseableHttpResponse) {
                CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpResponse;
                try {
                    closeableHttpResponse.close();
                }
                catch (IOException iOException) {}
            }
        }
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpAsyncClient getAsyncClient() {
        if (this.asyncClient == null || !this.asyncClient.isRunning()) {
            HttpClientService httpClientService = this;
            synchronized (httpClientService) {
                if (this.asyncClient == null || !this.asyncClient.isRunning()) {
                    this.asyncClient = this.createAsyncHttpClient();
                    this.asyncClient.start();
                }
            }
        }
        return this.asyncClient;
    }

    private CloseableHttpClient getSyncClient() {
        if (this.syncClient == null) {
            this.syncClient = this.createSyncHttpClient();
        }
        return this.syncClient;
    }

    private CloseableHttpAsyncClient createAsyncHttpClient() {
        HttpAsyncClientBuilder ab = HttpAsyncClients.custom();
        if (SpeechRecognitionSysConfig.httpUseProxy) {
            ab.setProxy(SpeechRecognitionSysConfig.httpHostProxy);
        }
        return ab.setConnectionManager((NHttpClientConnectionManager)this.connManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private CloseableHttpClient createSyncHttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(SpeechRecognitionSysConfig.MaxTotal);
        cm.setDefaultMaxPerRoute(SpeechRecognitionSysConfig.defaultMaxPerRoute);
        RequestConfig.Builder rb = RequestConfig.custom();
        if (SpeechRecognitionSysConfig.httpUseProxy) {
            rb.setProxy(SpeechRecognitionSysConfig.httpHostProxy);
        }
        RequestConfig requestConfig = rb.setConnectTimeout(SpeechRecognitionSysConfig.connectTimeout).setSocketTimeout(SpeechRecognitionSysConfig.socketTimeout).setConnectionRequestTimeout(SpeechRecognitionSysConfig.connectionRequestTimeout).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
    }
}

