/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConverter {
    public boolean canConvert(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return Object[][].class.equals((Object)type) || String[].class.equals((Object)type);
        }
        if (type instanceof ParameterizedType && List.class.isAssignableFrom((Class)(parameterizedType = (ParameterizedType)type).getRawType()) && parameterizedType.getActualTypeArguments().length == 1 && parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
            ParameterizedType innerType = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
            return List.class.isAssignableFrom((Class)innerType.getRawType());
        }
        return false;
    }

    public List<Object[]> convert(Object data, Class<?>[] parameterTypes, DataProvider dataProvider) {
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes must not be null");
        }
        if (dataProvider == null) {
            throw new NullPointerException("dataProvider must not be null");
        }
        if (parameterTypes.length == 0) {
            throw new IllegalArgumentException("parameterTypes must not be empty");
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (data instanceof Object[][]) {
            for (Object[] parameters : (Object[][])data) {
                result.add(parameters);
            }
        } else if (data instanceof String[]) {
            int idx = 0;
            for (String paramString : (String[])data) {
                result.add(this.getParametersFor(paramString, parameterTypes, dataProvider, idx++));
            }
        } else if (data instanceof List) {
            List lists = (List)data;
            for (List parameters : lists) {
                result.add(parameters.toArray());
            }
        } else {
            throw new ClassCastException(String.format("Cannot cast to either Object[][], String[], or List<List<Object>> because data was: %s", data));
        }
        return result;
    }

    public void checkIfArgumentsMatchParameterTypes(List<Object[]> arguments, Class<?>[] parameterTypes) {
        if (arguments == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("testMethod must not be null");
        }
        for (Object[] objects : arguments) {
            if (parameterTypes.length != objects.length) {
                throw new IllegalArgumentException(String.format("Expected %s arguments for test method but got %s parameters.", parameterTypes.length, objects.length));
            }
            for (int idx = 0; idx < objects.length; ++idx) {
                Class<?> paramType;
                Object object = objects[idx];
                if (object == null || (paramType = parameterTypes[idx]).isInstance(object) || this.isWrappedInstance(paramType, object) || this.isWideningConversion(paramType, object)) continue;
                throw new IllegalArgumentException(String.format("Parameter %d is of type %s but argument given is %s of type %s", idx, paramType.getSimpleName(), object, object.getClass().getSimpleName()));
            }
        }
    }

    Object[] getParametersFor(String data, Class<?>[] parameterTypes, DataProvider dataProvider, int rowIdx) {
        if (data == null) {
            return new Object[]{null};
        }
        String[] splitData = this.splitBy(data, dataProvider.splitBy());
        if (parameterTypes.length != splitData.length) {
            throw new IllegalArgumentException(String.format("Test method expected %d parameters but got %d from @DataProvider row %d", parameterTypes.length, splitData.length, rowIdx));
        }
        Object[] result = new Object[parameterTypes.length];
        for (int idx = 0; idx < splitData.length; ++idx) {
            String toConvert = dataProvider.trimValues() ? splitData[idx].trim() : splitData[idx];
            result[idx] = dataProvider.convertNulls() && "null".equals(toConvert) ? null : this.convertValue(toConvert, parameterTypes[idx]);
        }
        return result;
    }

    private String[] splitBy(String data, String regex) {
        String[] splitData = (data + "\u0000").split(regex);
        int lastItemIdx = splitData.length - 1;
        splitData[lastItemIdx] = splitData[lastItemIdx].substring(0, splitData[lastItemIdx].length() - 1);
        return splitData;
    }

    private Object convertValue(String str, Class<?> targetType) {
        if (String.class.equals(targetType)) {
            return str;
        }
        try {
            if (Boolean.TYPE.equals(targetType) || Boolean.class.equals(targetType)) {
                return Boolean.valueOf(str);
            }
            if (Byte.TYPE.equals(targetType) || Byte.class.equals(targetType)) {
                return Byte.valueOf(str);
            }
            if (Character.TYPE.equals(targetType) || Character.class.equals(targetType)) {
                return this.convertToChar(str, targetType);
            }
            if (Short.TYPE.equals(targetType) || Short.class.equals(targetType)) {
                return Short.valueOf(str);
            }
            if (Integer.TYPE.equals(targetType) || Integer.class.equals(targetType)) {
                return Integer.valueOf(str);
            }
            if (Long.TYPE.equals(targetType) || Long.class.equals(targetType)) {
                return this.convertToLong(str);
            }
            if (Float.TYPE.equals(targetType) || Float.class.equals(targetType)) {
                return Float.valueOf(str);
            }
            if (Double.TYPE.equals(targetType) || Double.class.equals(targetType)) {
                return Double.valueOf(str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to %s", str, targetType.getSimpleName()));
        }
        if (targetType.isEnum()) {
            return this.convertToEnumValue(str, targetType);
        }
        Object result = this.tryConvertUsingSingleStringParamConstructor(str, targetType);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("'" + targetType.getSimpleName() + "' is not supported as parameter type of test methods" + ". Supported types are primitive types and their wrappers, case-sensitive 'Enum'" + " values, 'String's, and types having a single 'String' parameter constructor.");
    }

    private boolean isWrappedInstance(Class<?> clazz, Object object) {
        return Boolean.TYPE.equals(clazz) && Boolean.class.isInstance(object) || Byte.TYPE.equals(clazz) && Byte.class.isInstance(object) || Character.TYPE.equals(clazz) && Character.class.isInstance(object) || Double.TYPE.equals(clazz) && Double.class.isInstance(object) || Float.TYPE.equals(clazz) && Float.class.isInstance(object) || Integer.TYPE.equals(clazz) && Integer.class.isInstance(object) || Long.TYPE.equals(clazz) && Long.class.isInstance(object) || Short.TYPE.equals(clazz) && Short.class.isInstance(object) || Void.TYPE.equals(clazz) && Void.class.isInstance(object);
    }

    private boolean isWideningConversion(Class<?> clazz, Object object) {
        if ((Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Byte.class.isInstance(object)) {
            return true;
        }
        if ((Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && (Short.class.isInstance(object) || Character.class.isInstance(object))) {
            return true;
        }
        if ((Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Integer.class.isInstance(object)) {
            return true;
        }
        if ((Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Long.class.isInstance(object)) {
            return true;
        }
        return Double.TYPE.equals(clazz) && Double.class.isInstance(object);
    }

    private Object convertToChar(String str, Class<?> charType) {
        if (str.length() == 1) {
            return Character.valueOf(str.charAt(0));
        }
        throw new IllegalArgumentException(String.format("'%s' cannot be converted to %s.", str, charType.getSimpleName()));
    }

    private Object convertToLong(String str) {
        String longStr = str;
        if (longStr.endsWith("l")) {
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return Long.valueOf(longStr);
    }

    private Object convertToEnumValue(String str, Class<?> enumType) {
        try {
            Object result = Enum.valueOf(enumType, str);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid value of enum %s. Please be aware of case sensitivity.", str, enumType.getSimpleName()));
        }
    }

    private Object tryConvertUsingSingleStringParamConstructor(String str, Class<?> targetType) {
        for (Constructor<?> constructor : targetType.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !String.class.equals(constructor.getParameterTypes()[0])) continue;
            try {
                return constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Tried to invoke '%s' for argument '%s'. Exception: %s", constructor, str, e.getMessage()), e);
            }
        }
        return null;
    }
}

