/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.server.VaadinSession;
import com.vaadin.spring.internal.BeanStore;
import org.springframework.beans.factory.ObjectFactory;

public class SessionLockingBeanStore
extends BeanStore {
    private static final long serialVersionUID = -5244428440915664554L;
    protected final VaadinSession session;

    protected SessionLockingBeanStore(VaadinSession session, String name, BeanStore.DestructionCallback destructionCallback) {
        super(name, destructionCallback);
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String s, ObjectFactory<?> objectFactory) {
        this.session.lock();
        try {
            Object object = super.get(s, objectFactory);
            return object;
        }
        finally {
            this.session.unlock();
        }
    }

    @Override
    public Object remove(String s) {
        this.session.lock();
        try {
            Object object = super.remove(s);
            return object;
        }
        finally {
            this.session.unlock();
        }
    }

    @Override
    public void destroy() {
        this.session.lock();
        try {
            super.destroy();
        }
        finally {
            this.session.unlock();
        }
    }

    @Override
    public void registerDestructionCallback(String s, Runnable runnable) {
        this.session.lock();
        try {
            super.registerDestructionCallback(s, runnable);
        }
        finally {
            this.session.unlock();
        }
    }
}

