/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Gauge;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricRegistry;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricSet;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Gauge<Long>> gauges = new HashMap<MetricName, Gauge<Long>>();
        gauges.put(MetricName.build("total.init"), () -> this.mxBean.getHeapMemoryUsage().getInit() + this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put(MetricName.build("total.used"), () -> this.mxBean.getHeapMemoryUsage().getUsed() + this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build("total.max"), () -> this.mxBean.getHeapMemoryUsage().getMax() + this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put(MetricName.build("total.committed"), () -> this.mxBean.getHeapMemoryUsage().getCommitted() + this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build("heap.init"), () -> this.mxBean.getHeapMemoryUsage().getInit());
        gauges.put(MetricName.build("heap.used"), () -> this.mxBean.getHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build("heap.max"), () -> this.mxBean.getHeapMemoryUsage().getMax());
        gauges.put(MetricName.build("heap.committed"), () -> this.mxBean.getHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build("heap.usage"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        gauges.put(MetricName.build("non-heap.init"), () -> this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put(MetricName.build("non-heap.used"), () -> this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build("non-heap.max"), () -> this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put(MetricName.build("non-heap.committed"), () -> this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build("non-heap.usage"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = "pools." + WHITESPACE.matcher(pool.getName()).replaceAll("-");
            gauges.put(MetricRegistry.name(poolName, "usage"), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage usage = pool.getUsage();
                    return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
                }
            });
            gauges.put(MetricRegistry.name(poolName, "max"), () -> pool.getUsage().getMax());
            gauges.put(MetricRegistry.name(poolName, "used"), () -> pool.getUsage().getUsed());
            gauges.put(MetricRegistry.name(poolName, "committed"), () -> pool.getUsage().getCommitted());
            if (pool.getCollectionUsage() != null) {
                gauges.put(MetricRegistry.name(poolName, "used-after-gc"), () -> pool.getCollectionUsage().getUsed());
            }
            gauges.put(MetricRegistry.name(poolName, "init"), () -> pool.getUsage().getInit());
        }
        return Collections.unmodifiableMap(gauges);
    }
}

