/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.values;

import de.codecentric.boot.admin.server.domain.values.Endpoint;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class Endpoints
implements Iterable<Endpoint>,
Serializable {
    private final Map<String, Endpoint> endpoints;
    private static final Endpoints EMPTY = new Endpoints(Collections.emptyList());

    private Endpoints(Collection<Endpoint> endpoints) {
        this.endpoints = endpoints.isEmpty() ? Collections.emptyMap() : endpoints.stream().collect(Collectors.toMap(Endpoint::getId, Function.identity()));
    }

    public Optional<Endpoint> get(String id) {
        return Optional.ofNullable(this.endpoints.get(id));
    }

    public boolean isPresent(String id) {
        return this.endpoints.containsKey(id);
    }

    @Override
    public Iterator<Endpoint> iterator() {
        return new UnmodifiableIterator<Endpoint>(this.endpoints.values().iterator());
    }

    public static Endpoints empty() {
        return EMPTY;
    }

    public static Endpoints single(String id, String url) {
        return new Endpoints(Collections.singletonList(Endpoint.of(id, url)));
    }

    public static Endpoints of(@Nullable Collection<Endpoint> endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            return Endpoints.empty();
        }
        return new Endpoints(endpoints);
    }

    public Endpoints withEndpoint(String id, String url) {
        Endpoint endpoint = Endpoint.of(id, url);
        HashMap<String, Endpoint> newEndpoints = new HashMap<String, Endpoint>(this.endpoints);
        newEndpoints.put(endpoint.getId(), endpoint);
        return new Endpoints(newEndpoints.values());
    }

    public Stream<Endpoint> stream() {
        return this.endpoints.values().stream();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoints)) {
            return false;
        }
        Endpoints other = (Endpoints)o;
        Map<String, Endpoint> this$endpoints = this.endpoints;
        Map<String, Endpoint> other$endpoints = other.endpoints;
        return !(this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Endpoint> $endpoints = this.endpoints;
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        return result;
    }

    public String toString() {
        return "Endpoints(endpoints=" + this.endpoints + ")";
    }

    private static final class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;

        private UnmodifiableIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }
    }
}

