/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractEventNotifier;
import de.codecentric.boot.admin.server.notify.Notifier;
import de.codecentric.boot.admin.server.notify.filter.ExpiringNotificationFilter;
import de.codecentric.boot.admin.server.notify.filter.NotificationFilter;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class FilteringNotifier
extends AbstractEventNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteringNotifier.class);
    private final ConcurrentMap<String, NotificationFilter> filters = new ConcurrentHashMap<String, NotificationFilter>();
    private final Notifier delegate;
    private Instant lastCleanup = Instant.EPOCH;
    private Duration cleanupInterval = Duration.ofSeconds(10L);

    public FilteringNotifier(Notifier delegate, InstanceRepository repository) {
        super(repository);
        Assert.notNull((Object)delegate, (String)"'delegate' must not be null!");
        this.delegate = delegate;
    }

    @Override
    protected boolean shouldNotify(InstanceEvent event, Instance instance) {
        return !this.filter(event, instance);
    }

    @Override
    public Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return this.delegate.notify(event);
    }

    private boolean filter(InstanceEvent event, Instance instance) {
        this.cleanUp();
        for (Map.Entry<String, NotificationFilter> entry : this.getNotificationFilters().entrySet()) {
            if (!entry.getValue().filter(event, instance)) continue;
            LOGGER.debug("The event '{}' was suppressed by filter '{}'", (Object)event, entry);
            return true;
        }
        return false;
    }

    private void cleanUp() {
        Instant now = Instant.now();
        if (this.lastCleanup.plus(this.cleanupInterval).isAfter(now)) {
            return;
        }
        this.lastCleanup = now;
        for (Map.Entry<String, NotificationFilter> entry : this.getNotificationFilters().entrySet()) {
            if (!(entry.getValue() instanceof ExpiringNotificationFilter) || !((ExpiringNotificationFilter)entry.getValue()).isExpired()) continue;
            LOGGER.debug("Expired filter '{}' removed", entry);
            this.filters.remove(entry.getKey());
        }
    }

    public void addFilter(NotificationFilter filter) {
        LOGGER.debug("Added filter '{}'", (Object)filter);
        this.filters.put(filter.getId(), filter);
    }

    @Nullable
    public NotificationFilter removeFilter(String id) {
        LOGGER.debug("Removed filter with id '{}'", (Object)id);
        return (NotificationFilter)this.filters.remove(id);
    }

    public Map<String, NotificationFilter> getNotificationFilters() {
        return Collections.unmodifiableMap(new HashMap<String, NotificationFilter>(this.filters));
    }

    public void setCleanupInterval(Duration cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }
}

