/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import de.codecentric.boot.admin.server.cloud.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.server.domain.values.Registration;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultServiceInstanceConverter
implements ServiceInstanceConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceInstanceConverter.class);
    private static final String KEY_MANAGEMENT_SCHEME = "management.scheme";
    private static final String KEY_MANAGEMENT_ADDRESS = "management.address";
    private static final String KEY_MANAGEMENT_PORT = "management.port";
    private static final String KEY_MANAGEMENT_PATH = "management.context-path";
    private static final String KEY_HEALTH_PATH = "health.path";
    private String managementContextPath = "/actuator";
    private String healthEndpointPath = "health";

    @Override
    public Registration convert(ServiceInstance instance) {
        LOGGER.debug("Converting service '{}' running at '{}' with metadata {}", new Object[]{instance.getServiceId(), instance.getUri(), instance.getMetadata()});
        return Registration.create((String)instance.getServiceId(), (String)this.getHealthUrl(instance).toString()).managementUrl(this.getManagementUrl(instance).toString()).serviceUrl(this.getServiceUrl(instance).toString()).metadata(this.getMetadata(instance)).build();
    }

    protected URI getHealthUrl(ServiceInstance instance) {
        return UriComponentsBuilder.fromUri((URI)this.getManagementUrl(instance)).path("/").path(this.getHealthPath(instance)).build().toUri();
    }

    protected String getHealthPath(ServiceInstance instance) {
        String healthPath = (String)instance.getMetadata().get(KEY_HEALTH_PATH);
        if (StringUtils.hasText((String)healthPath)) {
            return healthPath;
        }
        return this.healthEndpointPath;
    }

    protected URI getManagementUrl(ServiceInstance instance) {
        UriComponentsBuilder builder;
        URI serviceUrl = this.getServiceUrl(instance);
        String managementScheme = this.getManagementScheme(instance);
        String managementHost = this.getManagementHost(instance);
        int managementPort = this.getManagementPort(instance);
        if (serviceUrl.getHost().equals(managementHost) && serviceUrl.getScheme().equals(managementScheme) && serviceUrl.getPort() == managementPort) {
            builder = UriComponentsBuilder.fromUri((URI)serviceUrl);
        } else {
            builder = UriComponentsBuilder.newInstance().scheme(managementScheme).host(managementHost);
            if (managementPort != -1) {
                builder.port(managementPort);
            }
        }
        return builder.path("/").path(this.getManagementPath(instance)).build().toUri();
    }

    private String getManagementScheme(ServiceInstance instance) {
        String managementServerScheme = (String)instance.getMetadata().get(KEY_MANAGEMENT_SCHEME);
        if (StringUtils.hasText((String)managementServerScheme)) {
            return managementServerScheme;
        }
        return this.getServiceUrl(instance).getScheme();
    }

    protected String getManagementHost(ServiceInstance instance) {
        String managementServerHost = (String)instance.getMetadata().get(KEY_MANAGEMENT_ADDRESS);
        if (StringUtils.hasText((String)managementServerHost)) {
            return managementServerHost;
        }
        return this.getServiceUrl(instance).getHost();
    }

    protected int getManagementPort(ServiceInstance instance) {
        String managementPort = (String)instance.getMetadata().get(KEY_MANAGEMENT_PORT);
        if (StringUtils.hasText((String)managementPort)) {
            return Integer.parseInt(managementPort);
        }
        return this.getServiceUrl(instance).getPort();
    }

    protected String getManagementPath(ServiceInstance instance) {
        String managementPath = (String)instance.getMetadata().get(KEY_MANAGEMENT_PATH);
        if (StringUtils.hasText((String)managementPath)) {
            return managementPath;
        }
        return this.managementContextPath;
    }

    protected URI getServiceUrl(ServiceInstance instance) {
        return instance.getUri();
    }

    protected Map<String, String> getMetadata(ServiceInstance instance) {
        return instance.getMetadata() != null ? instance.getMetadata() : Collections.emptyMap();
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setHealthEndpointPath(String healthEndpointPath) {
        this.healthEndpointPath = healthEndpointPath;
    }

    public String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }
}

