/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.extensions;

import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class UiExtensionsScanner {
    private final ResourcePatternResolver resolver;

    public UiExtensionsScanner(ResourcePatternResolver resolver) {
        this.resolver = resolver;
    }

    public List<UiExtension> scan(String ... locations) throws IOException {
        ArrayList<UiExtension> extensions = new ArrayList<UiExtension>();
        for (String location : locations) {
            for (Resource resource : this.resolver.getResources(this.toPattern(location))) {
                String resourcePath = this.getResourcePath(location, resource);
                if (resourcePath == null || !this.isExtension(resource)) continue;
                extensions.add(new UiExtension(resourcePath, location + resourcePath));
            }
        }
        return extensions;
    }

    private String toPattern(String location) {
        return location.replace("classpath:", "classpath*:") + "**";
    }

    private boolean isExtension(Resource resource) {
        return resource.isReadable() && resource.getFilename().endsWith(".css") || resource.getFilename().endsWith(".js");
    }

    private String getResourcePath(String location, Resource resource) throws IOException {
        String locationWithouPrefix = location.replaceFirst("^[^:]+:", "");
        Matcher m = Pattern.compile(Pattern.quote(locationWithouPrefix) + "(.+)$").matcher(resource.getURI().toString());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

