/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.ContentType;
import dev.ai4j.openai4j.chat.ImageUrl;
import java.util.Objects;

public final class Content {
    private final ContentType type;
    private final String text;
    private final ImageUrl imageUrl;

    public Content(Builder builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.imageUrl = builder.imageUrl;
    }

    public ContentType type() {
        return this.type;
    }

    public String text() {
        return this.text;
    }

    public ImageUrl imageUrl() {
        return this.imageUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Content && this.equalTo((Content)another);
    }

    private boolean equalTo(Content another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.text, another.text) && Objects.equals(this.imageUrl, another.imageUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.imageUrl);
        return h;
    }

    public String toString() {
        return "Content{type=" + (Object)((Object)this.type) + ", text=" + this.text + ", imageUrl=" + this.imageUrl + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ContentType type;
        private String text;
        private ImageUrl imageUrl;

        public Builder type(ContentType type) {
            this.type = type;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder imageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Content build() {
            return new Content(this);
        }
    }
}

