/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chain;

import dev.langchain4j.chain.Chain;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.injector.ContentInjector;
import dev.langchain4j.rag.content.injector.DefaultContentInjector;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.retriever.Retriever;
import java.util.List;

public class ConversationalRetrievalChain
implements Chain<String, String> {
    private final ChatLanguageModel chatLanguageModel;
    private final ChatMemory chatMemory;
    private final RetrievalAugmentor retrievalAugmentor;

    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, ContentRetriever contentRetriever) {
        this(chatLanguageModel, chatMemory, (RetrievalAugmentor)DefaultRetrievalAugmentor.builder().contentRetriever(contentRetriever).build());
    }

    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, RetrievalAugmentor retrievalAugmentor) {
        this.chatLanguageModel = (ChatLanguageModel)ValidationUtils.ensureNotNull((Object)chatLanguageModel, (String)"chatLanguageModel");
        this.chatMemory = (ChatMemory)Utils.getOrDefault((Object)chatMemory, () -> MessageWindowChatMemory.withMaxMessages(10));
        this.retrievalAugmentor = (RetrievalAugmentor)ValidationUtils.ensureNotNull((Object)retrievalAugmentor, (String)"retrievalAugmentor");
    }

    @Deprecated
    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, PromptTemplate promptTemplate, Retriever<TextSegment> retriever) {
        this(chatLanguageModel, chatMemory, (RetrievalAugmentor)DefaultRetrievalAugmentor.builder().contentRetriever(retriever.toContentRetriever()).contentInjector((ContentInjector)DefaultContentInjector.builder().promptTemplate(ConversationalRetrievalChain.toPromptTemplateWithNewVariableNames(promptTemplate)).build()).build());
    }

    public String execute(String query) {
        UserMessage userMessage = UserMessage.from((String)query);
        userMessage = this.augment(userMessage);
        this.chatMemory.add((ChatMessage)userMessage);
        AiMessage aiMessage = (AiMessage)this.chatLanguageModel.generate(this.chatMemory.messages()).content();
        this.chatMemory.add((ChatMessage)aiMessage);
        return aiMessage.text();
    }

    private UserMessage augment(UserMessage userMessage) {
        Metadata metadata = Metadata.from((UserMessage)userMessage, (Object)this.chatMemory.id(), (List)this.chatMemory.messages());
        AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
        AugmentationResult augmentationResult = this.retrievalAugmentor.augment(augmentationRequest);
        return (UserMessage)augmentationResult.chatMessage();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static PromptTemplate toPromptTemplateWithNewVariableNames(PromptTemplate oldPromptTemplate) {
        if (oldPromptTemplate != null) {
            return PromptTemplate.from((String)oldPromptTemplate.template().replaceAll("\\{\\{question}}", "{{userMessage}}").replaceAll("\\{\\{information}}", "{{contents}}"));
        }
        return PromptTemplate.from((String)"Answer the following question to the best of your ability: {{userMessage}}\n\nBase your answer on the following information:\n{{contents}}");
    }

    public static class Builder {
        private ChatLanguageModel chatLanguageModel;
        private ChatMemory chatMemory;
        private RetrievalAugmentor retrievalAugmentor;
        @Deprecated
        private Retriever<TextSegment> retriever;
        @Deprecated
        private PromptTemplate promptTemplate;

        public Builder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public Builder chatMemory(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public Builder contentRetriever(ContentRetriever contentRetriever) {
            if (contentRetriever != null) {
                this.retrievalAugmentor = DefaultRetrievalAugmentor.builder().contentRetriever(contentRetriever).build();
            }
            return this;
        }

        public Builder retrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
            this.retrievalAugmentor = retrievalAugmentor;
            return this;
        }

        @Deprecated
        public Builder retriever(Retriever<TextSegment> retriever) {
            this.retriever = retriever;
            return this;
        }

        @Deprecated
        public Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public ConversationalRetrievalChain build() {
            if (this.retriever != null) {
                this.retrievalAugmentor = DefaultRetrievalAugmentor.builder().contentRetriever(this.retriever.toContentRetriever()).contentInjector((ContentInjector)DefaultContentInjector.builder().promptTemplate(ConversationalRetrievalChain.toPromptTemplateWithNewVariableNames(this.promptTemplate)).build()).build();
            }
            return new ConversationalRetrievalChain(this.chatLanguageModel, this.chatMemory, this.retrievalAugmentor);
        }
    }
}

