/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.Moderate;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.ServiceOutputParser;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.UserName;
import dev.langchain4j.service.V;
import java.io.InputStream;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class DefaultAiServices<T>
extends AiServices<T> {
    private static final int MAX_SEQUENTIAL_TOOL_EXECUTIONS = 10;

    DefaultAiServices(AiServiceContext context) {
        super(context);
    }

    static void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length < 2) {
            return;
        }
        for (Parameter parameter : parameters) {
            V v = parameter.getAnnotation(V.class);
            UserMessage userMessage = parameter.getAnnotation(UserMessage.class);
            MemoryId memoryId = parameter.getAnnotation(MemoryId.class);
            UserName userName = parameter.getAnnotation(UserName.class);
            if (v != null || userMessage != null || memoryId != null || userName != null) continue;
            throw IllegalConfigurationException.illegalConfiguration("Parameter '%s' of method '%s' should be annotated with @V or @UserMessage or @UserName or @MemoryId", parameter.getName(), method.getName());
        }
    }

    @Override
    public T build() {
        this.performBasicValidation();
        for (Method method : this.context.aiServiceClass.getMethods()) {
            if (method.isAnnotationPresent(Moderate.class) && this.context.moderationModel == null) {
                throw IllegalConfigurationException.illegalConfiguration("The @Moderate annotation is present, but the moderationModel is not set up. Please ensure a valid moderationModel is configured before using the @Moderate annotation.");
            }
            if (method.getReturnType() != Result.class) continue;
            this.validateResultReturnType(method);
        }
        Object proxyInstance = Proxy.newProxyInstance(this.context.aiServiceClass.getClassLoader(), new Class[]{this.context.aiServiceClass}, new InvocationHandler(){
            private final ExecutorService executor = Executors.newCachedThreadPool();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                List<ToolExecutionResultMessage> messages;
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                DefaultAiServices.validateParameters(method);
                String memoryId = DefaultAiServices.findMemoryId(method, args).orElse("default");
                Optional systemMessage = DefaultAiServices.this.prepareSystemMessage(memoryId, method, args);
                dev.langchain4j.data.message.UserMessage userMessage = DefaultAiServices.prepareUserMessage(method, args);
                AugmentationResult augmentationResult = null;
                if (DefaultAiServices.this.context.retrievalAugmentor != null) {
                    List chatMemory = DefaultAiServices.this.context.hasChatMemory() ? DefaultAiServices.this.context.chatMemory(memoryId).messages() : null;
                    Metadata metadata = Metadata.from((dev.langchain4j.data.message.UserMessage)userMessage, (Object)memoryId, (List)chatMemory);
                    AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
                    augmentationResult = DefaultAiServices.this.context.retrievalAugmentor.augment(augmentationRequest);
                    userMessage = (dev.langchain4j.data.message.UserMessage)augmentationResult.chatMessage();
                }
                Class<?> returnType = method.getReturnType();
                boolean isReturnTypeResult = false;
                if (returnType == Result.class) {
                    Type[] typeArguments;
                    isReturnTypeResult = true;
                    AnnotatedType annotatedReturnType = method.getAnnotatedReturnType();
                    ParameterizedType type = (ParameterizedType)annotatedReturnType.getType();
                    for (Type typeArg : typeArguments = type.getActualTypeArguments()) {
                        returnType = Class.forName(typeArg.getTypeName());
                    }
                }
                String outputFormatInstructions = ServiceOutputParser.outputFormatInstructions(returnType);
                String text = userMessage.singleText() + outputFormatInstructions;
                userMessage = Utils.isNotNullOrBlank((String)userMessage.name()) ? dev.langchain4j.data.message.UserMessage.from((String)userMessage.name(), (String)text) : dev.langchain4j.data.message.UserMessage.from((String)text);
                if (DefaultAiServices.this.context.hasChatMemory()) {
                    ChatMemory chatMemory = DefaultAiServices.this.context.chatMemory(memoryId);
                    systemMessage.ifPresent(arg_0 -> ((ChatMemory)chatMemory).add(arg_0));
                    chatMemory.add((ChatMessage)userMessage);
                }
                if (DefaultAiServices.this.context.hasChatMemory()) {
                    messages = DefaultAiServices.this.context.chatMemory(memoryId).messages();
                } else {
                    messages = new ArrayList();
                    systemMessage.ifPresent(messages::add);
                    messages.add((ToolExecutionResultMessage)((ChatMessage)userMessage));
                }
                Future<Moderation> moderationFuture = this.triggerModerationIfNeeded(method, messages);
                if (returnType == TokenStream.class) {
                    return new AiServiceTokenStream(messages, DefaultAiServices.this.context, memoryId);
                }
                Response response = DefaultAiServices.this.context.toolSpecifications == null ? DefaultAiServices.this.context.chatModel.generate(messages) : DefaultAiServices.this.context.chatModel.generate(messages, DefaultAiServices.this.context.toolSpecifications);
                TokenUsage tokenUsageAccumulator = response.tokenUsage();
                AiServices.verifyModerationIfNeeded(moderationFuture);
                int executionsLeft = 10;
                while (true) {
                    if (executionsLeft-- == 0) {
                        throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{10});
                    }
                    AiMessage aiMessage = (AiMessage)response.content();
                    if (DefaultAiServices.this.context.hasChatMemory()) {
                        DefaultAiServices.this.context.chatMemory(memoryId).add((ChatMessage)aiMessage);
                    } else {
                        messages = new ArrayList<ChatMessage>(messages);
                        messages.add((ToolExecutionResultMessage)((ChatMessage)aiMessage));
                    }
                    if (!aiMessage.hasToolExecutionRequests()) break;
                    for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                        ToolExecutor toolExecutor = DefaultAiServices.this.context.toolExecutors.get(toolExecutionRequest.name());
                        String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, memoryId);
                        ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                        if (DefaultAiServices.this.context.hasChatMemory()) {
                            DefaultAiServices.this.context.chatMemory(memoryId).add((ChatMessage)toolExecutionResultMessage);
                            continue;
                        }
                        messages.add(toolExecutionResultMessage);
                    }
                    if (DefaultAiServices.this.context.hasChatMemory()) {
                        messages = DefaultAiServices.this.context.chatMemory(memoryId).messages();
                    }
                    response = DefaultAiServices.this.context.chatModel.generate(messages, DefaultAiServices.this.context.toolSpecifications);
                    tokenUsageAccumulator = TokenUsage.sum((TokenUsage)tokenUsageAccumulator, (TokenUsage)response.tokenUsage());
                }
                response = Response.from((Object)((AiMessage)response.content()), (TokenUsage)tokenUsageAccumulator, (FinishReason)response.finishReason());
                Object parsedResponse = ServiceOutputParser.parse((Response<AiMessage>)response, returnType);
                if (isReturnTypeResult) {
                    return Result.builder().content(parsedResponse).tokenUsage(tokenUsageAccumulator).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(response.finishReason()).build();
                }
                return parsedResponse;
            }

            private Future<Moderation> triggerModerationIfNeeded(Method method, List<ChatMessage> messages) {
                if (method.isAnnotationPresent(Moderate.class)) {
                    return this.executor.submit(() -> {
                        List<ChatMessage> messagesToModerate = AiServices.removeToolMessages(messages);
                        return (Moderation)DefaultAiServices.this.context.moderationModel.moderate(messagesToModerate).content();
                    });
                }
                return null;
            }
        });
        return (T)proxyInstance;
    }

    private Optional<dev.langchain4j.data.message.SystemMessage> prepareSystemMessage(Object memoryId, Method method, Object[] args) {
        return this.findSystemMessageTemplate(memoryId, method).map(systemMessageTemplate -> PromptTemplate.from((String)systemMessageTemplate).apply(DefaultAiServices.findTemplateVariables(systemMessageTemplate, method, args)).toSystemMessage());
    }

    private Optional<String> findSystemMessageTemplate(Object memoryId, Method method) {
        SystemMessage annotation = method.getAnnotation(SystemMessage.class);
        if (annotation != null) {
            return Optional.of(DefaultAiServices.getTemplate(method, "System", annotation.fromResource(), annotation.value(), annotation.delimiter()));
        }
        return this.context.systemMessageProvider.apply(memoryId);
    }

    private static Map<String, Object> findTemplateVariables(String template, Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            V annotation = parameters[i].getAnnotation(V.class);
            if (annotation == null) continue;
            String variableName = annotation.value();
            Object variableValue = args[i];
            variables.put(variableName, variableValue);
        }
        if (template.contains("{{it}}") && !variables.containsKey("it")) {
            String itValue = DefaultAiServices.getValueOfVariableIt(parameters, args);
            variables.put("it", itValue);
        }
        return variables;
    }

    private static String getValueOfVariableIt(Parameter[] parameters, Object[] args) {
        Parameter parameter;
        if (!(parameters.length != 1 || (parameter = parameters[0]).isAnnotationPresent(MemoryId.class) || parameter.isAnnotationPresent(UserMessage.class) || parameter.isAnnotationPresent(UserName.class) || parameter.isAnnotationPresent(V.class) && !DefaultAiServices.isAnnotatedWithIt(parameter))) {
            return DefaultAiServices.toString(args[0]);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!DefaultAiServices.isAnnotatedWithIt(parameters[i])) continue;
            return DefaultAiServices.toString(args[i]);
        }
        throw IllegalConfigurationException.illegalConfiguration("Error: cannot find the value of the prompt template variable \"{{it}}\".");
    }

    private static boolean isAnnotatedWithIt(Parameter parameter) {
        V annotation = parameter.getAnnotation(V.class);
        return annotation != null && "it".equals(annotation.value());
    }

    private static dev.langchain4j.data.message.UserMessage prepareUserMessage(Method method, Object[] args) {
        String template = DefaultAiServices.getUserMessageTemplate(method, args);
        Map<String, Object> variables = DefaultAiServices.findTemplateVariables(template, method, args);
        Prompt prompt = PromptTemplate.from((String)template).apply(variables);
        Optional<String> maybeUserName = DefaultAiServices.findUserName(method.getParameters(), args);
        return maybeUserName.map(userName -> dev.langchain4j.data.message.UserMessage.from((String)userName, (String)prompt.text())).orElseGet(() -> ((Prompt)prompt).toUserMessage());
    }

    private static String getUserMessageTemplate(Method method, Object[] args) {
        Optional<String> templateFromMethodAnnotation = DefaultAiServices.findUserMessageTemplateFromMethodAnnotation(method);
        Optional<String> templateFromParameterAnnotation = DefaultAiServices.findUserMessageTemplateFromAnnotatedParameter(method.getParameters(), args);
        if (templateFromMethodAnnotation.isPresent() && templateFromParameterAnnotation.isPresent()) {
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' has multiple @UserMessage annotations. Please use only one.", method.getName());
        }
        if (templateFromMethodAnnotation.isPresent()) {
            return templateFromMethodAnnotation.get();
        }
        if (templateFromParameterAnnotation.isPresent()) {
            return templateFromParameterAnnotation.get();
        }
        Optional<String> templateFromTheOnlyArgument = DefaultAiServices.findUserMessageTemplateFromTheOnlyArgument(method.getParameters(), args);
        if (templateFromTheOnlyArgument.isPresent()) {
            return templateFromTheOnlyArgument.get();
        }
        throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' does not have a user message defined.", method.getName());
    }

    private static Optional<String> findUserMessageTemplateFromMethodAnnotation(Method method) {
        return Optional.ofNullable(method.getAnnotation(UserMessage.class)).map(a -> DefaultAiServices.getTemplate(method, "User", a.fromResource(), a.value(), a.delimiter()));
    }

    private static Optional<String> findUserMessageTemplateFromAnnotatedParameter(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class)) continue;
            return Optional.of(DefaultAiServices.toString(args[i]));
        }
        return Optional.empty();
    }

    private static Optional<String> findUserMessageTemplateFromTheOnlyArgument(Parameter[] parameters, Object[] args) {
        if (parameters != null && parameters.length == 1 && parameters[0].getAnnotations().length == 0) {
            return Optional.of(DefaultAiServices.toString(args[0]));
        }
        return Optional.empty();
    }

    private static Optional<String> findUserName(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserName.class)) continue;
            return Optional.of(args[i].toString());
        }
        return Optional.empty();
    }

    private static String getTemplate(Method method, String type, String resource, String[] value, String delimiter) {
        String messageTemplate;
        if (!resource.trim().isEmpty()) {
            messageTemplate = DefaultAiServices.getResourceText(method.getDeclaringClass(), resource);
            if (messageTemplate == null) {
                throw IllegalConfigurationException.illegalConfiguration("@%sMessage's resource '%s' not found", type, resource);
            }
        } else {
            messageTemplate = String.join((CharSequence)delimiter, value);
        }
        if (messageTemplate.trim().isEmpty()) {
            throw IllegalConfigurationException.illegalConfiguration("@%sMessage's template cannot be empty", type);
        }
        return messageTemplate;
    }

    private static String getResourceText(Class<?> clazz, String resource) {
        InputStream inputStream = clazz.getResourceAsStream(resource);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream("/" + resource);
        }
        return DefaultAiServices.getText(inputStream);
    }

    private static String getText(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(inputStream);){
            Scanner s = scanner.useDelimiter("\\A");
            try {
                String string;
                String string2 = string = s.hasNext() ? s.next() : "";
                if (s != null) {
                    s.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static Optional<Object> findMemoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(MemoryId.class)) continue;
            Object memoryId = args[i];
            if (memoryId == null) {
                throw Exceptions.illegalArgument((String)"The value of parameter '%s' annotated with @MemoryId in method '%s' must not be null", (Object[])new Object[]{parameters[i].getName(), method.getName()});
            }
            return Optional.of(memoryId);
        }
        return Optional.empty();
    }

    private static String toString(Object arg) {
        if (arg.getClass().isArray()) {
            return DefaultAiServices.arrayToString(arg);
        }
        if (arg.getClass().isAnnotationPresent(StructuredPrompt.class)) {
            return StructuredPromptProcessor.toPrompt((Object)arg).text();
        }
        return arg.toString();
    }

    private static String arrayToString(Object arg) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(arg);
        for (int i = 0; i < length; ++i) {
            sb.append(DefaultAiServices.toString(Array.get(arg, i)));
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

