/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.content.Content;
import java.util.List;

public class Result<T> {
    private final T content;
    private final TokenUsage tokenUsage;
    private final List<Content> sources;
    private final FinishReason finishReason;

    public Result(T content, TokenUsage tokenUsage, List<Content> sources, FinishReason finishReason) {
        this.content = ValidationUtils.ensureNotNull(content, (String)"content");
        this.tokenUsage = tokenUsage;
        this.sources = Utils.copyIfNotNull(sources);
        this.finishReason = finishReason;
    }

    public T content() {
        return this.content;
    }

    public TokenUsage tokenUsage() {
        return this.tokenUsage;
    }

    public List<Content> sources() {
        return this.sources;
    }

    public FinishReason finishReason() {
        return this.finishReason;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public static class ResultBuilder<T> {
        private T content;
        private TokenUsage tokenUsage;
        private List<Content> sources;
        private FinishReason finishReason;

        ResultBuilder() {
        }

        public ResultBuilder<T> content(T content) {
            this.content = content;
            return this;
        }

        public ResultBuilder<T> tokenUsage(TokenUsage tokenUsage) {
            this.tokenUsage = tokenUsage;
            return this;
        }

        public ResultBuilder<T> sources(List<Content> sources) {
            this.sources = sources;
            return this;
        }

        public ResultBuilder<T> finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.content, this.tokenUsage, this.sources, this.finishReason);
        }

        public String toString() {
            return "Result.ResultBuilder(content=" + this.content + ", tokenUsage=" + this.tokenUsage + ", sources=" + this.sources + ", finishReason=" + this.finishReason + ")";
        }
    }
}

