/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AiServiceStreamingResponseHandler
implements StreamingResponseHandler<AiMessage> {
    private final Logger log = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> tokenHandler;
    private final Consumer<Response<AiMessage>> completionHandler;
    private final Consumer<Throwable> errorHandler;
    private final List<ChatMessage> temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;

    AiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> tokenHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors) {
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.tokenHandler = (Consumer)ValidationUtils.ensureNotNull(tokenHandler, (String)"tokenHandler");
        this.completionHandler = completionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = new ArrayList<ChatMessage>(temporaryMemory);
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.toolSpecifications = Utils.copyIfNotNull(toolSpecifications);
        this.toolExecutors = Utils.copyIfNotNull(toolExecutors);
    }

    public void onNext(String token) {
        this.tokenHandler.accept(token);
    }

    public void onComplete(Response<AiMessage> response) {
        AiMessage aiMessage = (AiMessage)response.content();
        this.addToMemory((ChatMessage)aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                String toolName = toolExecutionRequest.name();
                ToolExecutor toolExecutor = this.toolExecutors.get(toolName);
                String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, this.memoryId);
                ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                this.addToMemory((ChatMessage)toolExecutionResultMessage);
            }
            this.context.streamingChatModel.generate(this.messagesToSend(this.memoryId), this.toolSpecifications, (StreamingResponseHandler)new AiServiceStreamingResponseHandler(this.context, this.memoryId, this.tokenHandler, this.completionHandler, this.errorHandler, this.temporaryMemory, TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)response.tokenUsage()), this.toolSpecifications, this.toolExecutors));
        } else if (this.completionHandler != null) {
            this.completionHandler.accept((Response<AiMessage>)Response.from((Object)aiMessage, (TokenUsage)TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)response.tokenUsage()), (FinishReason)response.finishReason()));
        }
    }

    private void addToMemory(ChatMessage chatMessage) {
        if (this.context.hasChatMemory()) {
            this.context.chatMemory(this.memoryId).add(chatMessage);
        } else {
            this.temporaryMemory.add(chatMessage);
        }
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.context.hasChatMemory() ? this.context.chatMemory(memoryId).messages() : this.temporaryMemory;
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                this.log.error("While handling the following error...", error);
                this.log.error("...the following error happened", (Throwable)e);
            }
        } else {
            this.log.warn("Ignored error", error);
        }
    }
}

