/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.service.output.BigDecimalOutputParser;
import dev.langchain4j.service.output.BigIntegerOutputParser;
import dev.langchain4j.service.output.BooleanOutputParser;
import dev.langchain4j.service.output.ByteOutputParser;
import dev.langchain4j.service.output.DateOutputParser;
import dev.langchain4j.service.output.DoubleOutputParser;
import dev.langchain4j.service.output.EnumListOutputParser;
import dev.langchain4j.service.output.EnumOutputParser;
import dev.langchain4j.service.output.EnumSetOutputParser;
import dev.langchain4j.service.output.FloatOutputParser;
import dev.langchain4j.service.output.IntOutputParser;
import dev.langchain4j.service.output.LocalDateOutputParser;
import dev.langchain4j.service.output.LocalDateTimeOutputParser;
import dev.langchain4j.service.output.LocalTimeOutputParser;
import dev.langchain4j.service.output.LongOutputParser;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.OutputParserFactory;
import dev.langchain4j.service.output.ShortOutputParser;
import dev.langchain4j.service.output.StringListOutputParser;
import dev.langchain4j.service.output.StringSetOutputParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class DefaultOutputParserFactory
implements OutputParserFactory {
    private static final Map<Class<?>, OutputParser<?>> OUTPUT_PARSERS = new HashMap();

    DefaultOutputParserFactory() {
    }

    @Override
    public Optional<OutputParser<?>> get(Class<?> rawClass, Class<?> typeArgumentClass) {
        OutputParser<?> outputParser;
        if (rawClass.isEnum()) {
            return Optional.of(new EnumOutputParser(rawClass.asSubclass(Enum.class)));
        }
        if (rawClass.equals(List.class)) {
            if (typeArgumentClass.isEnum()) {
                return Optional.of(new EnumListOutputParser(typeArgumentClass.asSubclass(Enum.class)));
            }
            if (typeArgumentClass.equals(String.class)) {
                return Optional.of(new StringListOutputParser());
            }
        }
        if (rawClass.equals(Set.class)) {
            if (typeArgumentClass.isEnum()) {
                return Optional.of(new EnumSetOutputParser(typeArgumentClass.asSubclass(Enum.class)));
            }
            if (typeArgumentClass.equals(String.class)) {
                return Optional.of(new StringSetOutputParser());
            }
        }
        if ((outputParser = OUTPUT_PARSERS.get(rawClass)) != null) {
            return Optional.of(outputParser);
        }
        return Optional.empty();
    }

    static {
        OUTPUT_PARSERS.put(Boolean.TYPE, new BooleanOutputParser());
        OUTPUT_PARSERS.put(Boolean.class, new BooleanOutputParser());
        OUTPUT_PARSERS.put(Byte.TYPE, new ByteOutputParser());
        OUTPUT_PARSERS.put(Byte.class, new ByteOutputParser());
        OUTPUT_PARSERS.put(Short.TYPE, new ShortOutputParser());
        OUTPUT_PARSERS.put(Short.class, new ShortOutputParser());
        OUTPUT_PARSERS.put(Integer.TYPE, new IntOutputParser());
        OUTPUT_PARSERS.put(Integer.class, new IntOutputParser());
        OUTPUT_PARSERS.put(Long.TYPE, new LongOutputParser());
        OUTPUT_PARSERS.put(Long.class, new LongOutputParser());
        OUTPUT_PARSERS.put(BigInteger.class, new BigIntegerOutputParser());
        OUTPUT_PARSERS.put(Float.TYPE, new FloatOutputParser());
        OUTPUT_PARSERS.put(Float.class, new FloatOutputParser());
        OUTPUT_PARSERS.put(Double.TYPE, new DoubleOutputParser());
        OUTPUT_PARSERS.put(Double.class, new DoubleOutputParser());
        OUTPUT_PARSERS.put(BigDecimal.class, new BigDecimalOutputParser());
        OUTPUT_PARSERS.put(Date.class, new DateOutputParser());
        OUTPUT_PARSERS.put(LocalDate.class, new LocalDateOutputParser());
        OUTPUT_PARSERS.put(LocalTime.class, new LocalTimeOutputParser());
        OUTPUT_PARSERS.put(LocalDateTime.class, new LocalDateTimeOutputParser());
    }
}

