/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.output.DefaultOutputParserFactory;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.OutputParserFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceOutputParser {
    private static final Pattern JSON_BLOCK_PATTERN = Pattern.compile("(?s)\\{.*\\}|\\[.*\\]");
    private final OutputParserFactory outputParserFactory;

    public ServiceOutputParser() {
        this(new DefaultOutputParserFactory());
    }

    ServiceOutputParser(OutputParserFactory outputParserFactory) {
        this.outputParserFactory = (OutputParserFactory)ValidationUtils.ensureNotNull((Object)outputParserFactory, (String)"outputParserFactory");
    }

    public Object parse(Response<AiMessage> response, Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterClass(returnType);
        }
        Class<?> rawReturnClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        if (rawReturnClass == Response.class) {
            return response;
        }
        AiMessage aiMessage = (AiMessage)response.content();
        if (rawReturnClass == AiMessage.class) {
            return aiMessage;
        }
        String text = aiMessage.text();
        if (rawReturnClass == String.class) {
            return text;
        }
        Optional<OutputParser<?>> optionalOutputParser = this.outputParserFactory.get(rawReturnClass, typeArgumentClass);
        if (optionalOutputParser.isPresent()) {
            return optionalOutputParser.get().parse(text);
        }
        try {
            return Json.fromJson((String)text, rawReturnClass);
        }
        catch (Exception e) {
            String jsonBlock = this.extractJsonBlock(text);
            return Json.fromJson((String)jsonBlock, rawReturnClass);
        }
    }

    public String outputFormatInstructions(Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterClass(returnType);
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        if (rawClass == String.class || rawClass == AiMessage.class || rawClass == TokenStream.class || rawClass == Response.class) {
            return "";
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        Optional<OutputParser<?>> outputParser = this.outputParserFactory.get(rawClass, typeArgumentClass);
        if (outputParser.isPresent()) {
            String formatInstructions = outputParser.get().formatInstructions();
            if (rawClass == List.class || rawClass == Set.class || rawClass.isEnum()) {
                return formatInstructions;
            }
            return "\nYou must answer strictly in the following format: " + formatInstructions;
        }
        String jsonStructure = ServiceOutputParser.jsonStructure(rawClass, new HashSet());
        this.validateJsonStructure(jsonStructure, returnType);
        return "\nYou must answer strictly in the following JSON format: " + jsonStructure;
    }

    private void validateJsonStructure(String jsonStructure, Type returnType) {
        if (jsonStructure.replaceAll("\\s", "").equals("{}")) {
            if (returnType.toString().contains("reactor.core.publisher.Flux")) {
                throw IllegalConfigurationException.illegalConfiguration("Please import langchain4j-reactor module if you wish to use Flux<String> as a method return type");
            }
            throw IllegalConfigurationException.illegalConfiguration("Illegal method return type: " + returnType);
        }
    }

    private static String jsonStructure(Class<?> structured, Set<Class<?>> visited) {
        StringBuilder jsonSchema = new StringBuilder();
        jsonSchema.append("{\n");
        for (Field field : structured.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("__$hits$__") || Modifier.isStatic(field.getModifiers())) continue;
            jsonSchema.append(String.format("\"%s\": (%s),\n", name, ServiceOutputParser.descriptionFor(field, visited)));
        }
        int trailingCommaIndex = jsonSchema.lastIndexOf(",");
        if (trailingCommaIndex > 0) {
            jsonSchema.delete(trailingCommaIndex, trailingCommaIndex + 1);
        }
        jsonSchema.append("}");
        return jsonSchema.toString();
    }

    private static String descriptionFor(Field field, Set<Class<?>> visited) {
        Description fieldDescription = field.getAnnotation(Description.class);
        if (fieldDescription == null) {
            return "type: " + ServiceOutputParser.typeOf(field, visited);
        }
        return String.join((CharSequence)" ", fieldDescription.value()) + "; type: " + ServiceOutputParser.typeOf(field, visited);
    }

    private static String typeOf(Field field, Set<Class<?>> visited) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Set.class)) {
                return String.format("array of %s", ServiceOutputParser.simpleNameOrJsonStructure((Class)typeArguments[0], visited));
            }
        } else {
            if (field.getType().isArray()) {
                return String.format("array of %s", ServiceOutputParser.simpleNameOrJsonStructure(field.getType().getComponentType(), visited));
            }
            if (((Class)type).isEnum()) {
                return "enum, must be one of " + Arrays.toString(((Class)type).getEnumConstants());
            }
        }
        return ServiceOutputParser.simpleNameOrJsonStructure(field.getType(), visited);
    }

    private static String simpleNameOrJsonStructure(Class<?> structured, Set<Class<?>> visited) {
        String simpleTypeName = ServiceOutputParser.simpleTypeName(structured);
        if (structured.getPackage() == null || structured.getPackage().getName().startsWith("java.") || visited.contains(structured)) {
            return simpleTypeName;
        }
        visited.add(structured);
        return simpleTypeName + ": " + ServiceOutputParser.jsonStructure(structured, visited);
    }

    private static String simpleTypeName(Type type) {
        switch (type.getTypeName()) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": 
            case "int": {
                return "integer";
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "java.lang.Float": 
            case "float": {
                return "float";
            }
            case "java.lang.Double": 
            case "double": {
                return "double";
            }
            case "java.util.Date": 
            case "java.time.LocalDate": {
                return "date string (2023-12-31)";
            }
            case "java.time.LocalTime": {
                return "time string (23:59:59)";
            }
            case "java.time.LocalDateTime": {
                return "date-time string (2023-12-31T23:59:59)";
            }
        }
        return type.getTypeName();
    }

    private String extractJsonBlock(String text) {
        Matcher matcher = JSON_BLOCK_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return text;
    }
}

