/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.Utils;
import java.util.Objects;

public class ToolExecution {
    private final ToolExecutionRequest request;
    private final String result;

    private ToolExecution(Builder builder) {
        this.request = builder.request;
        this.result = builder.result;
    }

    public ToolExecutionRequest request() {
        return this.request;
    }

    public String result() {
        return this.result;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ToolExecution && this.equalTo((ToolExecution)another);
    }

    private boolean equalTo(ToolExecution another) {
        return Objects.equals(this.request, another.request) && Objects.equals(this.result, another.result);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.request);
        h += (h << 5) + Objects.hashCode(this.result);
        return h;
    }

    public String toString() {
        return "ToolExecution { request = " + this.request + ", result = " + Utils.quoted((Object)this.result) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ToolExecutionRequest request;
        private String result;

        private Builder() {
        }

        public Builder request(ToolExecutionRequest request) {
            this.request = request;
            return this;
        }

        public Builder result(String result) {
            this.result = result;
            return this;
        }

        public ToolExecution build() {
            return new ToolExecution(this);
        }
    }
}

