/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.internal.Json;
import dev.langchain4j.service.tool.ToolExecutionRequestUtil;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolExecutor
implements ToolExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultToolExecutor.class);
    private final Object object;
    private final Method originalMethod;
    private final Method methodToInvoke;

    public DefaultToolExecutor(Object object, Method method) {
        this.object = Objects.requireNonNull(object, "object");
        this.methodToInvoke = this.originalMethod = Objects.requireNonNull(method, "method");
    }

    public DefaultToolExecutor(Object object, ToolExecutionRequest toolExecutionRequest) {
        this.object = Objects.requireNonNull(object, "object");
        Objects.requireNonNull(toolExecutionRequest, "toolExecutionRequest");
        this.methodToInvoke = this.originalMethod = this.findMethod(object, toolExecutionRequest);
    }

    private Method findMethod(Object object, ToolExecutionRequest toolExecutionRequest) {
        String requestedMethodName = toolExecutionRequest.name();
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(requestedMethodName)) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("Method '%s' is not found in object '%s'", requestedMethodName, object.getClass().getName()));
    }

    public DefaultToolExecutor(Object object, Method originalMethod, Method methodToInvoke) {
        this.object = Objects.requireNonNull(object, "object");
        this.originalMethod = Objects.requireNonNull(originalMethod, "originalMethod");
        this.methodToInvoke = Objects.requireNonNull(methodToInvoke, "methodToInvoke");
    }

    @Override
    public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
        log.debug("About to execute {} for memoryId {}", (Object)toolExecutionRequest, memoryId);
        Map<String, Object> argumentsMap = ToolExecutionRequestUtil.argumentsAsMap(toolExecutionRequest.arguments());
        Object[] arguments = DefaultToolExecutor.prepareArguments(this.originalMethod, argumentsMap, memoryId);
        try {
            String result = this.execute(arguments);
            log.debug("Tool execution result: {}", (Object)result);
            return result;
        }
        catch (IllegalAccessException e) {
            try {
                this.methodToInvoke.setAccessible(true);
                String result = this.execute(arguments);
                log.debug("Tool execution result: {}", (Object)result);
                return result;
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                log.error("Error while executing tool", cause);
                return cause.getMessage();
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            log.error("Error while executing tool", cause);
            return cause.getMessage();
        }
    }

    private String execute(Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Object result = this.methodToInvoke.invoke(this.object, arguments);
        Class<?> returnType = this.methodToInvoke.getReturnType();
        if (returnType == Void.TYPE) {
            return "Success";
        }
        if (returnType == String.class) {
            return (String)result;
        }
        return Json.toJson((Object)result);
    }

    static Object[] prepareArguments(Method method, Map<String, Object> argumentsMap, Object memoryId) {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(ToolMemoryId.class)) {
                arguments[i] = memoryId;
                continue;
            }
            String parameterName = parameter.getName();
            if (!argumentsMap.containsKey(parameterName)) continue;
            Object argument = argumentsMap.get(parameterName);
            Class<?> parameterClass = parameter.getType();
            Type parameterType = parameter.getParameterizedType();
            arguments[i] = DefaultToolExecutor.coerceArgument(argument, parameterName, parameterClass, parameterType);
        }
        return arguments;
    }

    static Object coerceArgument(Object argument, String parameterName, Class<?> parameterClass, Type parameterType) {
        Class<?> type;
        if (parameterClass == String.class) {
            return argument.toString();
        }
        if (parameterClass.isEnum()) {
            try {
                Class<?> enumClass = parameterClass;
                try {
                    return Enum.valueOf(enumClass, Objects.requireNonNull(argument).toString());
                }
                catch (IllegalArgumentException e) {
                    return Enum.valueOf(enumClass, Objects.requireNonNull(argument).toString().toUpperCase());
                }
            }
            catch (Error | Exception e) {
                throw new IllegalArgumentException(String.format("Argument \"%s\" is not a valid enum value for %s: <%s>", parameterName, parameterClass.getName(), argument), e);
            }
        }
        if (parameterClass == Boolean.class || parameterClass == Boolean.TYPE) {
            if (argument instanceof Boolean) {
                return argument;
            }
            throw new IllegalArgumentException(String.format("Argument \"%s\" is not convertable to %s, got %s: <%s>", parameterName, parameterClass.getName(), argument.getClass().getName(), argument));
        }
        if (parameterClass == Double.class || parameterClass == Double.TYPE) {
            return DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterClass);
        }
        if (parameterClass == Float.class || parameterClass == Float.TYPE) {
            double doubleValue = DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterClass);
            DefaultToolExecutor.checkBounds(doubleValue, parameterName, parameterClass, -1.4E-45f, 3.4028234663852886E38);
            return Float.valueOf((float)doubleValue);
        }
        if (parameterClass == BigDecimal.class) {
            return BigDecimal.valueOf(DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterClass));
        }
        if (parameterClass == Integer.class || parameterClass == Integer.TYPE) {
            return (int)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterClass, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (parameterClass == Long.class || parameterClass == Long.TYPE) {
            return DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterClass, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (parameterClass == Short.class || parameterClass == Short.TYPE) {
            return (short)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterClass, -32768L, 32767L);
        }
        if (parameterClass == Byte.class || parameterClass == Byte.TYPE) {
            return (byte)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterClass, -128L, 127L);
        }
        if (parameterClass == BigInteger.class) {
            return BigDecimal.valueOf(DefaultToolExecutor.getNonFractionalDoubleValue(argument, parameterName, parameterClass)).toBigInteger();
        }
        if (parameterClass.isArray() && argument instanceof Collection && (type = parameterClass.getComponentType()) == String.class) {
            return ((Collection)argument).toArray(new String[0]);
        }
        if (Collection.class.isAssignableFrom(parameterClass) || Map.class.isAssignableFrom(parameterClass)) {
            return Json.fromJson((String)Json.toJson((Object)argument), (Type)parameterType);
        }
        if (argument instanceof String) {
            return Json.fromJson((String)argument.toString(), parameterClass);
        }
        String result = Json.toJson((Object)argument);
        return Json.fromJson((String)result, parameterClass);
    }

    private static double getDoubleValue(Object argument, String parameterName, Class<?> parameterType) {
        if (argument instanceof String) {
            try {
                return Double.parseDouble(argument.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(argument instanceof Number)) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" is not convertable to %s, got %s: <%s>", parameterName, parameterType.getName(), argument.getClass().getName(), argument));
        }
        return ((Number)argument).doubleValue();
    }

    private static double getNonFractionalDoubleValue(Object argument, String parameterName, Class<?> parameterType) {
        double doubleValue = DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterType);
        if (!DefaultToolExecutor.hasNoFractionalPart(doubleValue)) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" has non-integer value for %s: <%s>", parameterName, parameterType.getName(), argument));
        }
        return doubleValue;
    }

    private static void checkBounds(double doubleValue, String parameterName, Class<?> parameterType, double minValue, double maxValue) {
        if (doubleValue < minValue || doubleValue > maxValue) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" is out of range for %s: <%s>", parameterName, parameterType.getName(), doubleValue));
        }
    }

    private static long getBoundedLongValue(Object argument, String parameterName, Class<?> parameterType, long minValue, long maxValue) {
        double doubleValue = DefaultToolExecutor.getNonFractionalDoubleValue(argument, parameterName, parameterType);
        DefaultToolExecutor.checkBounds(doubleValue, parameterName, parameterType, minValue, maxValue);
        return (long)doubleValue;
    }

    static boolean hasNoFractionalPart(Double doubleValue) {
        return doubleValue.equals(Math.floor(doubleValue));
    }
}

