/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.HallucinatedToolNameStrategy;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionContext;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ToolService {
    private static final int MAX_SEQUENTIAL_TOOL_EXECUTIONS = 100;
    private List<ToolSpecification> toolSpecifications;
    private Map<String, ToolExecutor> toolExecutors;
    private ToolProvider toolProvider;
    private Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy = HallucinatedToolNameStrategy.THROW_EXCEPTION;

    public void hallucinatedToolNameStrategy(Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy) {
        this.toolHallucinationStrategy = toolHallucinationStrategy;
    }

    public void toolProvider(ToolProvider toolProvider) {
        if (this.toolSpecifications != null || this.toolExecutors != null) {
            throw new IllegalArgumentException("Either the tools or the tool provider can be configured, but not both!");
        }
        this.toolProvider = toolProvider;
    }

    public void tools(Map<ToolSpecification, ToolExecutor> tools) {
        if (this.toolProvider != null) {
            throw new IllegalArgumentException("Either the tools or the tool provider can be configured, but not both!");
        }
        this.initTools();
        tools.forEach((toolSpecification, toolExecutor) -> {
            this.toolSpecifications.add((ToolSpecification)toolSpecification);
            this.toolExecutors.put(toolSpecification.name(), (ToolExecutor)toolExecutor);
        });
    }

    public void tools(Collection<Object> objectsWithTools) {
        if (this.toolProvider != null) {
            throw new IllegalArgumentException("Either the tools or the tool provider can be configured, but not both!");
        }
        this.initTools();
        for (Object objectWithTool : objectsWithTools) {
            if (objectWithTool instanceof Class) {
                throw IllegalConfigurationException.illegalConfiguration("Tool '%s' must be an object, not a class", objectWithTool);
            }
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)method);
                if (this.toolExecutors.containsKey(toolSpecification.name())) {
                    throw new IllegalConfigurationException("Duplicated definition for tool: " + toolSpecification.name());
                }
                this.toolExecutors.put(toolSpecification.name(), new DefaultToolExecutor(objectWithTool, method));
                this.toolSpecifications.add(ToolSpecifications.toolSpecificationFrom((Method)method));
            }
        }
    }

    public void initTools() {
        if (this.toolSpecifications == null) {
            this.toolSpecifications = new ArrayList<ToolSpecification>();
        }
        if (this.toolExecutors == null) {
            this.toolExecutors = new HashMap<String, ToolExecutor>();
        }
    }

    public ToolExecutionContext executionContext(Object memoryId, UserMessage userMessage) {
        if (this.toolProvider == null) {
            return new ToolExecutionContext(this.toolSpecifications, this.toolExecutors);
        }
        ArrayList<ToolSpecification> toolsSpecs = new ArrayList<ToolSpecification>();
        HashMap<String, ToolExecutor> toolExecs = new HashMap<String, ToolExecutor>();
        ToolProviderRequest toolProviderRequest = new ToolProviderRequest(memoryId, userMessage);
        ToolProviderResult toolProviderResult = this.toolProvider.provideTools(toolProviderRequest);
        if (toolProviderResult != null) {
            for (Map.Entry<ToolSpecification, ToolExecutor> entry : toolProviderResult.tools().entrySet()) {
                toolsSpecs.add(entry.getKey());
                toolExecs.put(entry.getKey().name(), entry.getValue());
            }
        }
        return new ToolExecutionContext(toolsSpecs, toolExecs);
    }

    public ToolExecutionResult executeInferenceAndToolsLoop(ChatResponse chatResponse, ChatRequestParameters parameters, List<ChatMessage> messages, ChatLanguageModel chatModel, ChatMemory chatMemory, Object memoryId, Map<String, ToolExecutor> toolExecutors) {
        TokenUsage tokenUsageAccumulator = chatResponse.metadata().tokenUsage();
        int executionsLeft = 100;
        ArrayList<ToolExecution> toolExecutions = new ArrayList<ToolExecution>();
        while (true) {
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{100});
            }
            AiMessage aiMessage = chatResponse.aiMessage();
            if (chatMemory != null) {
                chatMemory.add((ChatMessage)aiMessage);
            } else {
                messages = new ArrayList<ChatMessage>(messages);
                messages.add((ChatMessage)aiMessage);
            }
            if (!aiMessage.hasToolExecutionRequests()) break;
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                ToolExecutor toolExecutor = toolExecutors.get(toolExecutionRequest.name());
                ToolExecutionResultMessage toolExecutionResultMessage = toolExecutor == null ? this.toolHallucinationStrategy.apply(toolExecutionRequest) : ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutor.execute(toolExecutionRequest, memoryId));
                toolExecutions.add(ToolExecution.builder().request(toolExecutionRequest).result(toolExecutionResultMessage.text()).build());
                if (chatMemory != null) {
                    chatMemory.add((ChatMessage)toolExecutionResultMessage);
                    continue;
                }
                messages.add(toolExecutionResultMessage);
            }
            if (chatMemory != null) {
                messages = chatMemory.messages();
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).build();
            chatResponse = chatModel.chat(chatRequest);
            tokenUsageAccumulator = TokenUsage.sum((TokenUsage)tokenUsageAccumulator, (TokenUsage)chatResponse.metadata().tokenUsage());
        }
        return new ToolExecutionResult(chatResponse, toolExecutions, tokenUsageAccumulator);
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public ToolProvider toolProvider() {
        return this.toolProvider;
    }
}

