/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.LinkedHashMap;
import java.util.Map;

public class ToolProviderResult {
    private final Map<ToolSpecification, ToolExecutor> tools;

    public ToolProviderResult(Map<ToolSpecification, ToolExecutor> tools) {
        this.tools = Utils.copy(tools);
    }

    public Map<ToolSpecification, ToolExecutor> tools() {
        return this.tools;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<ToolSpecification, ToolExecutor> tools = new LinkedHashMap<ToolSpecification, ToolExecutor>();

        public Builder add(ToolSpecification tool, ToolExecutor executor) {
            this.tools.put(tool, executor);
            return this;
        }

        public Builder addAll(Map<ToolSpecification, ToolExecutor> tools) {
            this.tools.putAll(tools);
            return this;
        }

        public ToolProviderResult build() {
            return new ToolProviderResult(this.tools);
        }
    }
}

