/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.memory.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.SingleSlotChatMemoryStore;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class MessageWindowChatMemory
implements ChatMemory {
    private final Object id;
    private final Integer maxMessages;
    private final ChatMemoryStore store;

    private MessageWindowChatMemory(Builder builder) {
        this.id = ValidationUtils.ensureNotNull((Object)builder.id, (String)"id");
        this.maxMessages = ValidationUtils.ensureGreaterThanZero((Integer)builder.maxMessages, (String)"maxMessages");
        this.store = (ChatMemoryStore)ValidationUtils.ensureNotNull((Object)builder.store(), (String)"store");
    }

    public Object id() {
        return this.id;
    }

    public void add(ChatMessage message) {
        Optional<SystemMessage> systemMessage;
        List<ChatMessage> messages = this.messages();
        if (message instanceof SystemMessage && (systemMessage = MessageWindowChatMemory.findSystemMessage(messages)).isPresent()) {
            if (systemMessage.get().equals((Object)message)) {
                return;
            }
            messages.remove(systemMessage.get());
        }
        messages.add(message);
        MessageWindowChatMemory.ensureCapacity(messages, this.maxMessages);
        this.store.updateMessages(this.id, messages);
    }

    private static Optional<SystemMessage> findSystemMessage(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).findAny();
    }

    public List<ChatMessage> messages() {
        LinkedList<ChatMessage> messages = new LinkedList<ChatMessage>(this.store.getMessages(this.id));
        MessageWindowChatMemory.ensureCapacity(messages, this.maxMessages);
        return messages;
    }

    private static void ensureCapacity(List<ChatMessage> messages, int maxMessages) {
        while (messages.size() > maxMessages) {
            AiMessage aiMessage;
            ChatMessage evictedMessage;
            int messageToEvictIndex = 0;
            if (messages.get(0) instanceof SystemMessage) {
                messageToEvictIndex = 1;
            }
            if (!((evictedMessage = messages.remove(messageToEvictIndex)) instanceof AiMessage) || !(aiMessage = (AiMessage)evictedMessage).hasToolExecutionRequests()) continue;
            while (messages.size() > messageToEvictIndex && messages.get(messageToEvictIndex) instanceof ToolExecutionResultMessage) {
                messages.remove(messageToEvictIndex);
            }
        }
    }

    public void clear() {
        this.store.deleteMessages(this.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageWindowChatMemory withMaxMessages(int maxMessages) {
        return MessageWindowChatMemory.builder().maxMessages(maxMessages).build();
    }

    public static class Builder {
        private Object id = "default";
        private Integer maxMessages;
        private ChatMemoryStore store;

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder maxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public Builder chatMemoryStore(ChatMemoryStore store) {
            this.store = store;
            return this;
        }

        private ChatMemoryStore store() {
            return this.store != null ? this.store : new SingleSlotChatMemoryStore(this.id);
        }

        public MessageWindowChatMemory build() {
            return new MessageWindowChatMemory(this);
        }
    }
}

