/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class AiServiceStreamingResponseHandler
implements StreamingChatResponseHandler {
    private final Logger log = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> partialResponseHandler;
    private final Consumer<ToolExecution> toolExecutionHandler;
    private final Consumer<ChatResponse> completeResponseHandler;
    private final Consumer<Throwable> errorHandler;
    private final List<ChatMessage> temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;

    AiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> partialResponseHandler, Consumer<ToolExecution> toolExecutionHandler, Consumer<ChatResponse> completeResponseHandler, Consumer<Throwable> errorHandler, List<ChatMessage> temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors) {
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.partialResponseHandler = (Consumer)ValidationUtils.ensureNotNull(partialResponseHandler, (String)"partialResponseHandler");
        this.completeResponseHandler = completeResponseHandler;
        this.toolExecutionHandler = toolExecutionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = new ArrayList<ChatMessage>(temporaryMemory);
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.toolSpecifications = Utils.copy(toolSpecifications);
        this.toolExecutors = Utils.copy(toolExecutors);
    }

    public void onPartialResponse(String partialResponse) {
        this.partialResponseHandler.accept(partialResponse);
    }

    public void onCompleteResponse(ChatResponse completeResponse) {
        AiMessage aiMessage = completeResponse.aiMessage();
        this.addToMemory((ChatMessage)aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                String toolName = toolExecutionRequest.name();
                ToolExecutor toolExecutor = this.toolExecutors.get(toolName);
                String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, this.memoryId);
                ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutionResult);
                this.addToMemory((ChatMessage)toolExecutionResultMessage);
                if (this.toolExecutionHandler == null) continue;
                ToolExecution toolExecution = ToolExecution.builder().request(toolExecutionRequest).result(toolExecutionResult).build();
                this.toolExecutionHandler.accept(toolExecution);
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(this.messagesToSend(this.memoryId)).toolSpecifications(this.toolSpecifications).build();
            AiServiceStreamingResponseHandler handler = new AiServiceStreamingResponseHandler(this.context, this.memoryId, this.partialResponseHandler, this.toolExecutionHandler, this.completeResponseHandler, this.errorHandler, this.temporaryMemory, TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)completeResponse.metadata().tokenUsage()), this.toolSpecifications, this.toolExecutors);
            this.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)handler);
        } else if (this.completeResponseHandler != null) {
            ChatResponse finalChatResponse = ChatResponse.builder().aiMessage(aiMessage).metadata(completeResponse.metadata().toBuilder().tokenUsage(this.tokenUsage.add(completeResponse.metadata().tokenUsage())).build()).build();
            this.completeResponseHandler.accept(finalChatResponse);
        }
    }

    private void addToMemory(ChatMessage chatMessage) {
        if (this.context.hasChatMemory()) {
            this.context.chatMemoryService.getOrCreateChatMemory(this.memoryId).add(chatMessage);
        } else {
            this.temporaryMemory.add(chatMessage);
        }
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.context.hasChatMemory() ? this.context.chatMemoryService.getOrCreateChatMemory(memoryId).messages() : this.temporaryMemory;
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                this.log.error("While handling the following error...", error);
                this.log.error("...the following error happened", (Throwable)e);
            }
        } else {
            this.log.warn("Ignored error", error);
        }
    }
}

