/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceStreamingResponseHandler;
import dev.langchain4j.service.AiServiceTokenStreamParameters;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@Internal
public class AiServiceTokenStream
implements TokenStream {
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final List<Content> retrievedContents;
    private final AiServiceContext context;
    private final Object memoryId;
    private final GuardrailRequestParams commonGuardrailParams;
    private final Object methodKey;
    private Consumer<String> partialResponseHandler;
    private Consumer<List<Content>> contentsHandler;
    private Consumer<ToolExecution> toolExecutionHandler;
    private Consumer<ChatResponse> completeResponseHandler;
    private Consumer<Throwable> errorHandler;
    private int onPartialResponseInvoked;
    private int onCompleteResponseInvoked;
    private int onRetrievedInvoked;
    private int onToolExecutedInvoked;
    private int onErrorInvoked;
    private int ignoreErrorsInvoked;

    public AiServiceTokenStream(AiServiceTokenStreamParameters parameters) {
        ValidationUtils.ensureNotNull((Object)parameters, (String)"parameters");
        this.messages = Utils.copy((List)((List)ValidationUtils.ensureNotEmpty(parameters.messages(), (String)"messages")));
        this.toolSpecifications = Utils.copy(parameters.toolSpecifications());
        this.toolExecutors = Utils.copy(parameters.toolExecutors());
        this.retrievedContents = Utils.copy(parameters.gretrievedContents());
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)parameters.context(), (String)"context");
        ValidationUtils.ensureNotNull((Object)this.context.streamingChatModel, (String)"streamingChatModel");
        this.memoryId = ValidationUtils.ensureNotNull((Object)parameters.memoryId(), (String)"memoryId");
        this.commonGuardrailParams = parameters.commonGuardrailParams();
        this.methodKey = parameters.methodKey();
    }

    @Override
    public TokenStream onPartialResponse(Consumer<String> partialResponseHandler) {
        this.partialResponseHandler = partialResponseHandler;
        ++this.onPartialResponseInvoked;
        return this;
    }

    @Override
    public TokenStream onRetrieved(Consumer<List<Content>> contentsHandler) {
        this.contentsHandler = contentsHandler;
        ++this.onRetrievedInvoked;
        return this;
    }

    @Override
    public TokenStream onToolExecuted(Consumer<ToolExecution> toolExecutionHandler) {
        this.toolExecutionHandler = toolExecutionHandler;
        ++this.onToolExecutedInvoked;
        return this;
    }

    @Override
    public TokenStream onCompleteResponse(Consumer<ChatResponse> completionHandler) {
        this.completeResponseHandler = completionHandler;
        ++this.onCompleteResponseInvoked;
        return this;
    }

    @Override
    public TokenStream onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        ++this.onErrorInvoked;
        return this;
    }

    @Override
    public TokenStream ignoreErrors() {
        this.errorHandler = null;
        ++this.ignoreErrorsInvoked;
        return this;
    }

    @Override
    public void start() {
        this.validateConfiguration();
        ChatRequest chatRequest = ChatRequest.builder().messages(this.messages).toolSpecifications(this.toolSpecifications).build();
        ChatExecutor chatExecutor = ChatExecutor.builder((StreamingChatModel)this.context.streamingChatModel).errorHandler(this.errorHandler).chatRequest(chatRequest).build();
        AiServiceStreamingResponseHandler handler = new AiServiceStreamingResponseHandler(chatExecutor, this.context, this.memoryId, this.partialResponseHandler, this.toolExecutionHandler, this.completeResponseHandler, this.errorHandler, this.initTemporaryMemory(this.context, this.messages), new TokenUsage(), this.toolSpecifications, this.toolExecutors, this.commonGuardrailParams, this.methodKey);
        if (this.contentsHandler != null && this.retrievedContents != null) {
            this.contentsHandler.accept(this.retrievedContents);
        }
        this.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)handler);
    }

    private void validateConfiguration() {
        if (this.onPartialResponseInvoked != 1) {
            throw new IllegalConfigurationException("onPartialResponse must be invoked on TokenStream exactly 1 time");
        }
        if (this.onCompleteResponseInvoked > 1) {
            throw new IllegalConfigurationException("onCompleteResponse can be invoked on TokenStream at most 1 time");
        }
        if (this.onRetrievedInvoked > 1) {
            throw new IllegalConfigurationException("onRetrieved can be invoked on TokenStream at most 1 time");
        }
        if (this.onToolExecutedInvoked > 1) {
            throw new IllegalConfigurationException("onToolExecuted can be invoked on TokenStream at most 1 time");
        }
        if (this.onErrorInvoked + this.ignoreErrorsInvoked != 1) {
            throw new IllegalConfigurationException("One of [onError, ignoreErrors] must be invoked on TokenStream exactly 1 time");
        }
    }

    private ChatMemory initTemporaryMemory(AiServiceContext context, List<ChatMessage> messagesToSend) {
        MessageWindowChatMemory chatMemory = MessageWindowChatMemory.withMaxMessages(Integer.MAX_VALUE);
        if (!context.hasChatMemory()) {
            chatMemory.add(messagesToSend);
        }
        return chatMemory;
    }
}

