/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.azure.aisearch.spring;

import com.azure.search.documents.indexes.models.SearchIndex;
import dev.langchain4j.azure.aisearch.spring.Properties;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.content.retriever.azure.search.AzureAiSearchContentRetriever;
import dev.langchain4j.store.embedding.azure.search.AzureAiSearchEmbeddingStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;

@AutoConfiguration
@EnableConfigurationProperties(value={Properties.class})
public class AutoConfig {
    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure.ai-search.content-retriever.api-key"})
    public AzureAiSearchContentRetriever azureAiSearchContentRetriever(Properties properties, @Nullable EmbeddingModel embeddingModel, @Nullable SearchIndex index) {
        Properties.NestedProperties nestedProperties = properties.getContentRetriever();
        return AzureAiSearchContentRetriever.builder().endpoint(nestedProperties.getEndpoint()).apiKey(nestedProperties.getApiKey()).createOrUpdateIndex(nestedProperties.getCreateOrUpdateIndex().booleanValue()).embeddingModel(embeddingModel).dimensions(nestedProperties.getDimensions() == null ? 0 : nestedProperties.getDimensions()).index(index).maxResults(nestedProperties.getMaxResults().intValue()).minScore(nestedProperties.getMinScore() == null ? 0.0 : nestedProperties.getMinScore()).queryType(nestedProperties.getQueryType()).build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure.ai-search.embedding-store.api-key"})
    public AzureAiSearchEmbeddingStore azureAiSearchEmbeddingStore(Properties properties, @Nullable EmbeddingModel embeddingModel, @Nullable SearchIndex index) {
        Properties.NestedProperties nestedProperties = properties.getEmbeddingStore();
        return AzureAiSearchEmbeddingStore.builder().endpoint(nestedProperties.getEndpoint()).apiKey(nestedProperties.getApiKey()).createOrUpdateIndex(nestedProperties.getCreateOrUpdateIndex().booleanValue()).dimensions(nestedProperties.getDimensions().intValue()).index(index).build();
    }
}

