/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.data.document.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import java.util.Map;
import java.util.Objects;

@Experimental
public class GraphNode {
    private final String id;
    private final String type;
    private final Map<String, String> properties;

    public GraphNode(String id, String type, Map<String, String> properties) {
        this.id = id;
        this.type = (String)Utils.getOrDefault((Object)type, (Object)"Node");
        this.properties = Utils.copy(properties);
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String type() {
        return this.type;
    }

    @JsonProperty
    public Map<String, String> properties() {
        return this.properties;
    }

    public static GraphNode from(String id, String type, Map<String, String> properties) {
        return new GraphNode(id, type, properties);
    }

    public static GraphNode from(String id, String type) {
        return new GraphNode(id, type, Map.of());
    }

    public static GraphNode from(String id) {
        return new GraphNode(id, null, Map.of());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNode graphNode = (GraphNode)o;
        return Objects.equals(this.id, graphNode.id) && Objects.equals(this.type, graphNode.type) && Objects.equals(this.properties, graphNode.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.properties);
    }

    public String toString() {
        return "GraphNode{id='" + this.id + "', type='" + this.type + "', properties=" + String.valueOf(this.properties) + "}";
    }
}

