/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.QwenStreamingResponseBuilder;
import dev.langchain4j.community.model.dashscope.spi.QwenStreamingLanguageModelBuilderFactory;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class QwenStreamingLanguageModel
implements StreamingLanguageModel {
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;
    private Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer = p -> {};

    public QwenStreamingLanguageModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. Reference: https://www.alibabacloud.com/help/en/model-studio/get-api-key");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.generation = Utils.isNullOrBlank((String)baseUrl) ? new Generation() : (baseUrl.startsWith("wss://") ? new Generation(Protocol.WEBSOCKET.getValue(), baseUrl) : new Generation(Protocol.HTTP.getValue(), baseUrl));
    }

    public void generate(String prompt, final StreamingResponseHandler<String> handler) {
        boolean incrementalOutput = QwenHelper.isSupportingIncrementalOutputModelName(this.modelName);
        try {
            GenerationParam.GenerationParamBuilder builder = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).repetitionPenalty(this.repetitionPenalty).temperature(this.temperature).maxTokens(this.maxTokens).incrementalOutput(Boolean.valueOf(incrementalOutput)).prompt(prompt)).resultFormat(GenerationParam.ResultFormat.MESSAGE);
            if (this.stops != null) {
                builder.stopStrings(this.stops);
            }
            this.generationParamCustomizer.accept(builder);
            final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder(this.modelName, incrementalOutput);
            this.generation.streamCall((HalfDuplexServiceParam)builder.build(), (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrBlank((String)delta)) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    ChatResponse response = responseBuilder.build();
                    handler.onComplete(Response.from((Object)response.aiMessage().text(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason()));
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setGenerationParamCustomizer(Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer) {
        this.generationParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(generationParamCustomizer, (String)"generationParamConsumer");
    }

    public static QwenStreamingLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenStreamingLanguageModelBuilderFactory factory = (QwenStreamingLanguageModelBuilderFactory)iterator.next();
            return (QwenStreamingLanguageModelBuilder)factory.get();
        }
        return new QwenStreamingLanguageModelBuilder();
    }

    public static class QwenStreamingLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;

        public QwenStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenStreamingLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenStreamingLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenStreamingLanguageModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenStreamingLanguageModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenStreamingLanguageModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenStreamingLanguageModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenStreamingLanguageModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenStreamingLanguageModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenStreamingLanguageModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenStreamingLanguageModel build() {
            return new QwenStreamingLanguageModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens);
        }
    }
}

