/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.qianfan.client.chat.Function;
import dev.langchain4j.community.model.qianfan.client.chat.FunctionCall;
import dev.langchain4j.community.model.qianfan.client.chat.Message;
import dev.langchain4j.community.model.qianfan.client.chat.Parameters;
import dev.langchain4j.community.model.qianfan.client.chat.Role;
import dev.langchain4j.community.model.qianfan.client.completion.CompletionResponse;
import dev.langchain4j.community.model.qianfan.client.embedding.EmbeddingResponse;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
class InternalQianfanHelper {
    private InternalQianfanHelper() throws InstantiationException {
        throw new InstantiationException("Can not instantiate utility class");
    }

    static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalQianfanHelper::toFunction).collect(Collectors.toList());
    }

    static Message toQianfanMessage(ChatMessage message) {
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return Message.builder().role(Role.USER).content(userMessage.singleText()).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return Message.builder().content(aiMessage.text()).role(Role.ASSISTANT).build();
            }
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            if (toolExecutionRequest.id() == null) {
                FunctionCall functionCall = FunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build();
                return Message.builder().content(aiMessage.text()).role(Role.ASSISTANT).functionCall(functionCall).build();
            }
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            FunctionCall functionCall = FunctionCall.builder().name(toolExecutionResultMessage.toolName()).arguments(toolExecutionResultMessage.text()).build();
            return Message.builder().content(toolExecutionResultMessage.text()).role(Role.FUNCTION).name(functionCall.getName()).build();
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(message.type())), (Object[])new Object[0]);
    }

    static TokenUsage tokenUsageFrom(ChatCompletionResponse response) {
        return Optional.of(response).map(ChatCompletionResponse::getUsage).map(usage -> new TokenUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens())).orElse(null);
    }

    static TokenUsage tokenUsageFrom(CompletionResponse response) {
        return Optional.of(response).map(CompletionResponse::getUsage).map(usage -> new TokenUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens())).orElse(null);
    }

    static TokenUsage tokenUsageFrom(EmbeddingResponse response) {
        return Optional.of(response).map(EmbeddingResponse::getUsage).map(usage -> new TokenUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens())).orElse(null);
    }

    static FinishReason finishReasonFrom(String finishReason) {
        if (Utils.isNullOrBlank((String)finishReason)) {
            return null;
        }
        return switch (finishReason) {
            case "normal", "stop" -> FinishReason.STOP;
            case "length" -> FinishReason.LENGTH;
            case "content_filter" -> FinishReason.CONTENT_FILTER;
            case "function_call" -> FinishReason.TOOL_EXECUTION;
            default -> null;
        };
    }

    static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        FunctionCall functionCall = response.getFunctionCall();
        if (functionCall != null) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.getName()).arguments(functionCall.getArguments()).build();
            return AiMessage.aiMessage((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest});
        }
        return AiMessage.aiMessage((String)response.getResult());
    }

    static String getSystemMessage(List<ChatMessage> messages) {
        List systemMessages = messages.stream().filter(message -> message instanceof SystemMessage).collect(Collectors.toList());
        if (systemMessages.size() > 1) {
            throw new RuntimeException("Multiple system messages are not supported");
        }
        if (Utils.isNullOrEmpty(systemMessages)) {
            return null;
        }
        return ((SystemMessage)systemMessages.get(0)).text();
    }

    static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        List<Message> aiMessages = messages.stream().filter(chatMessage -> !(chatMessage instanceof SystemMessage)).map(InternalQianfanHelper::toQianfanMessage).collect(Collectors.toList());
        if (aiMessages.isEmpty() || aiMessages.size() % 2 == 1) {
            return aiMessages;
        }
        aiMessages.remove(0);
        return aiMessages;
    }

    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description((String)Utils.getOrDefault((Object)toolSpecification.description(), (Object)toolSpecification.name())).parameters(InternalQianfanHelper.toOpenAiParameters(toolSpecification)).build();
    }

    private static Parameters toOpenAiParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            JsonObjectSchema parameters = toolSpecification.parameters();
            return Parameters.builder().properties(JsonSchemaElementUtils.toMap((Map)parameters.properties())).required(parameters.required()).build();
        }
        return Parameters.builder().build();
    }
}

