/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.community.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.community.model.qianfan.QianfanChatModelNameEnum;
import dev.langchain4j.community.model.qianfan.client.QianfanClient;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.qianfan.spi.QianfanChatModelBuilderFactory;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;
import java.util.List;

public class QianfanChatModel
implements ChatModel {
    private final QianfanClient client;
    private final List<ChatModelListener> listeners;
    private final Integer maxRetries;
    private final ChatRequestParameters defaultRequestParameters;
    private final String endpoint;
    private final String userId;
    private final String system;

    public QianfanChatModel(String baseUrl, String apiKey, String secretKey, Double temperature, Integer maxRetries, Double topP, String modelName, String endpoint, String responseFormat, Double penaltyScore, Boolean logRequests, Boolean logResponses, String userId, List<String> stop, Integer maxOutputTokens, String system, Proxy proxy, List<ChatModelListener> listeners) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanChatModelNameEnum.fromModelName(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan does not have such model name. You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.listeners = Utils.copy(listeners);
        this.client = QianfanClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com")).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logResponses(logResponses).proxy(proxy).build();
        this.defaultRequestParameters = ChatRequestParameters.builder().temperature(temperature).topP(topP).stopSequences(stop).modelName((String)ValidationUtils.ensureNotNull((Object)modelName, (String)"modelName")).maxOutputTokens(maxOutputTokens).responseFormat("json_object".equals(responseFormat) ? ResponseFormat.JSON : ResponseFormat.TEXT).presencePenalty(penaltyScore).build();
        this.userId = userId;
        this.system = system;
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        List messages = chatRequest.messages();
        List toolSpecifications = chatRequest.toolSpecifications();
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder().messages(InternalQianfanHelper.toOpenAiMessages(messages)).temperature(parameters.temperature()).topP(parameters.topP()).maxOutputTokens(parameters.maxOutputTokens()).stop(parameters.stopSequences()).system(this.system).userId(this.userId).penaltyScore(parameters.presencePenalty()).responseFormat(parameters.responseFormat() == ResponseFormat.JSON ? "json_object" : "text");
        if (this.system == null || this.system.isEmpty()) {
            builder.system(InternalQianfanHelper.getSystemMessage(messages));
        }
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            builder.functions(InternalQianfanHelper.toFunctions(toolSpecifications));
        }
        ChatCompletionRequest param = builder.build();
        ChatCompletionResponse response = (ChatCompletionResponse)RetryUtils.withRetry(() -> (ChatCompletionResponse)this.client.chatCompletion(param, this.endpoint).execute(), (int)this.maxRetries);
        return ChatResponse.builder().aiMessage(InternalQianfanHelper.aiMessageFrom(response)).tokenUsage(InternalQianfanHelper.tokenUsageFrom(response)).finishReason(InternalQianfanHelper.finishReasonFrom(response.getFinishReason())).build();
    }

    public static QianfanChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanChatModelBuilderFactory factory = (QianfanChatModelBuilderFactory)iterator.next();
            return (QianfanChatModelBuilder)factory.get();
        }
        return new QianfanChatModelBuilder();
    }

    public static class QianfanChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Double temperature;
        private Integer maxRetries;
        private Double topP;
        private String modelName;
        private String endpoint;
        private String responseFormat;
        private Double penaltyScore;
        private Boolean logRequests;
        private Boolean logResponses;
        private String userId;
        private List<String> stop;
        private Integer maxOutputTokens;
        private String system;
        private Proxy proxy;
        private List<ChatModelListener> listeners;

        public QianfanChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanChatModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public QianfanChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public QianfanChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QianfanChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanChatModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public QianfanChatModelBuilder penaltyScore(Double penaltyScore) {
            this.penaltyScore = penaltyScore;
            return this;
        }

        public QianfanChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanChatModelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QianfanChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public QianfanChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public QianfanChatModelBuilder system(String system) {
            this.system = system;
            return this;
        }

        public QianfanChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QianfanChatModel build() {
            return new QianfanChatModel(this.baseUrl, this.apiKey, this.secretKey, this.temperature, this.maxRetries, this.topP, this.modelName, this.endpoint, this.responseFormat, this.penaltyScore, this.logRequests, this.logResponses, this.userId, this.stop, this.maxOutputTokens, this.system, this.proxy, this.listeners);
        }
    }
}

