/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan.client.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Parameters {
    private final String type;
    private final Map<String, Map<String, Object>> properties;
    private final List<String> required;

    private Parameters(Builder builder) {
        this.type = builder.type;
        this.properties = builder.properties;
        this.required = builder.required;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Map<String, Object>> getProperties() {
        return this.properties;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Parameters && this.equalTo((Parameters)another);
    }

    private boolean equalTo(Parameters another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.properties, another.properties) && Objects.equals(this.required, another.required);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.properties);
        h += (h << 5) + Objects.hashCode(this.required);
        return h;
    }

    public String toString() {
        return "Parameters{type=" + this.type + ", properties=" + String.valueOf(this.properties) + ", required=" + String.valueOf(this.required) + "}";
    }

    public static final class Builder {
        private String type = "object";
        private Map<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        private List<String> required = new ArrayList<String>();

        private Builder() {
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder properties(Map<String, Map<String, Object>> properties) {
            this.properties = properties;
            return this;
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }
    }
}

